/*
 * place_popup.c,v 2.1 1992/06/23 00:29:17 pete Exp
 * place_popup.c,v
 * Revision 2.1  1992/06/23  00:29:17  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:52:52  ware
 * First public release.
 *
 * Revision 1.6  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.5  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.4  1992/02/12  00:51:30  ware
 * Added, the untested, XoPlaceRelative() function to place a popup widget
 * in relation to its parent.
 *
 * Revision 1.3  91/08/26  11:58:52  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.2  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.1  1991/06/14  04:51:20  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xo/XoP.h>
#include <X11/Xo/Label.h>
#include <X11/Xo/dbug.h>

/*
 * XoPlacePopup	- position a shell at the specified location.  Make
 *	sure the shell remains on the screen, even if that
 *	means placing it differently
 */

void
XoPlacePopup (popup, x, y)
	Widget          popup;		/* shell widget */
	int             x;		/* x & y location */
	int             y;
{
	Arg             args[10];
	Cardinal        cnt;
	Position        popup_x, popup_y;
	Dimension       popup_width, popup_height;
	int             excess;
	Screen         *screen;
	int             screen_width, screen_height;
	Widget          attach_to;

	DBUG_ENTER ("XoPlacePopup");
	cnt = 0;
	XtSetArg (args[cnt], XtNwidth, &popup_width); ++cnt;
	XtSetArg (args[cnt], XtNheight, &popup_height); ++cnt;
	XtGetValues (popup, args, cnt);
	attach_to = XtParent (popup);

	/*
	 * Get screen that these widgets are being displayed on and retrieve
	 * its size.
	 */
	if ((screen = XtScreen (attach_to)) == (Screen *) NULL)
	{
		DBUG_VOID_RETURN;
	}

	screen_width = WidthOfScreen (screen);
	screen_height = HeightOfScreen (screen);

	/*
	 * Now calculate a position for the popup that attempts to place the
	 * upper left corner of the popup in the specified location with the
	 * constraint that the popup must be entirely within the bounds of
	 * the screen.
	 */
	if (popup_width >= screen_width)
	{
		popup_x = 0;
	}
	else
	{
		popup_x = x;

		/*
		 * Adjust if menu extends off of the screen.
		 */

		if ((excess = popup_x + popup_width - screen_width) > 0)
		{
			popup_x -= excess;
		}
	}
	if (popup_height >= screen_height)
	{
		popup_y = 0;
	}
	else
	{
		popup_y = y;

		/*
		 * Adjust if menu extends off of the screen.
		 */
		if ((excess = popup_y + popup_height - screen_height) > 0)
		{
			popup_y -= excess;
		}
	}
	cnt = 0;
	XtSetArg (args[cnt], XtNx, popup_x); ++cnt;
	XtSetArg (args[cnt], XtNy, popup_y); ++cnt;
	XtSetValues (popup, args, cnt);
	DBUG_VOID_RETURN;
}

/*
 * Place a widget relative to another widget.  Assumes screen coordinates,
 * however.
 */

void
XoPlaceRelative (gw, parent, where, part, keep_on_screen)
	Widget          gw;		/* widget to place */
	Widget          parent;		/* widget to place gw relative to */
	XoGravity       where;		/* which part */
	XoGravity	part;		/* part of child to place at where */
	int             keep_on_screen;	/* if insure full visible */
{
	Position        parent_x;	/* location of parent */
	Position        parent_y;
	Position	child_x, child_y;
	Position        popup_x;	/* new location of popup */
	Position        popup_y;
	Arg             args[10];
	Cardinal        cnt;

	if (!parent)
	{
		_XoWarn (gw, "bad Parent", "XoPlaceParentRelative",
		     "This widget has no parent to place it relative too.");
		return;
	}
	if (!XoShellGet (gw))
	{
		_XoWarn (gw, "bad Shell", "XoPlaceParentRelative",
			 "Widget is NULL or has no appropriate parent");
		return;
	}

	XoWidgetGravityPoint (parent, part, &parent_x, &parent_y);
	XoWidgetGravityPoint (gw, where, &child_x, &child_y);
	/*
	 * We attempt to deal with virtual root window managers at this
	 * point.  The assumption is that such a window manager treats
	 * the PPostion hint as relative to the virtual root and
	 * so must be set correctly
	 */
	if (XtIsRealized (parent))
	{
		int	_x, _y;
		Window	child;

		XTranslateCoordinates (XtDisplay (parent),
				       XtWindow (parent),
				       XoVirtualRootWindowOfScreen (XtScreen (parent)),
				       (int) parent_x, (int) parent_y,
				       &_x, &_y, &child);
		parent_x = _x;
		parent_y = _y;
	}
	else
	{
		XtTranslateCoords (parent, parent_x, parent_y,
				   &parent_x, &parent_y);
		
	}

	/*
	 * FIX: Need to account for border_widths added by window manager
	 */
	popup_x = parent_x - child_x;
	popup_y = parent_y - child_y;
	if (keep_on_screen)
	{
		XoPlacePopup (XoShellGet (gw), (int) popup_x, (int) popup_y);
	}
	else
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNx, popup_x); ++cnt;
		XtSetArg (args[cnt], XtNy, popup_y); ++cnt;
		XtSetValues (XoShellGet (gw), args, cnt);
	}
}

void
XoWidgetLoc (gw, x_ret, y_ret, w_ret, h_ret)
	Widget		gw;		/* widget */
	Position	*x_ret;		/* x location returned */
	Position	*y_ret;		/* y location returned */
	Dimension	*w_ret;		/* width returned */
	Dimension	*h_ret;		/* height returned */
{
	Arg		args[10];
	Cardinal	cnt;

	cnt = 0;
	XtSetArg (args[cnt], XtNx, x_ret); ++cnt;
	XtSetArg (args[cnt], XtNy, y_ret); ++cnt;
	XtSetArg (args[cnt], XtNwidth, w_ret); ++cnt;
	XtSetArg (args[cnt], XtNheight, h_ret); ++cnt;
	XtGetValues (gw, args, cnt);
}

/*
 * Find the point on the screen relative to gw.  The point to find
 * is "where" and is something like North, Northeast, ..., NorthWest, Center.
 */
void
XoWidgetGravityPoint (gw, where, x_ret, y_ret)
	Widget		gw;		/* widget to return point of */
	XoGravity	where;		/* point in widget to return */
	Position	*x_ret;		/* returned x and y coordinate */
	Position	*y_ret;
{
	Dimension	width;
	Dimension	height;
	Position	x;
	Position	y;

	/*
	 * FIX: Someday we should really determine values for the border
	 */

	if (!gw)
		return;
	XoWidgetLoc (gw, &x, &y, &width, &height);
	switch (where)
	{
	default:
		_XoWarn (gw, "bad Argument", "XoWidgetGravityPoint",
			 "No such gravity.  Using XoCENTER instead");
		/* Yes, fall through to XoCENTER */
	case XoCENTER:
		*x_ret = width / 2;
		*y_ret = height / 2;
		break;
	case XoNORTHWEST:
		*x_ret = 0;
		*y_ret = 0;
		break;
	case XoNORTH:
		*x_ret = width / 2;
		*y_ret = 0;
		break;
	case XoNORTHEAST:
		*x_ret = width;
		*y_ret = 0;
		break;
	case XoEAST:
		*x_ret = width;
		*y_ret = height / 2;
		break;
	case XoSOUTHEAST:
		*x_ret = width;
		*y_ret = height;
		break;
	case XoSOUTH:
		*x_ret = width / 2;
		*y_ret = height;
		break;
	case XoSOUTHWEST:
		*x_ret = 0;
		*y_ret = height;
		break;
	case XoWEST:
		*x_ret = 0;
		*y_ret = height/ 2;
		break;
	}
}
