/*
 * FontFamily.h,v 2.0 1992/04/23 02:46:48 ware Exp
 * FontFamily.h,v
 * Revision 2.0  1992/04/23  02:46:48  ware
 * First public release.
 *
 * Revision 1.1  1992/02/23  21:16:25  ware
 * Initial revision
 *
 * Revision 1.0  91/08/22  15:33:56  gnb
 * Initial revision
 * 
 * 
 */

/*

Copyright 1990,1991 by the Massachusetts Institute of Technology

All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of the Massachusetts
Institute of Technology (M.I.T.) not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.

M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/

#ifndef _At_FontFamily_h
#define _At_FontFamily_h    

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
/* have to include Intrinsic.h to get definition
   of Cardinal for type converter */    

/* type faces */
#define AtFontPLAIN       0
#define AtFontBOLD        1      /* set and clear these two bits to get */
#define AtFontITALIC      2      /* the 4 possible typefaces */
#define AtFontBOLDITALIC  3

/* point sizes */
#define AtFontSMALLEST 0 
#define AtFontSMALL    1 
#define AtFontMEDIUM   2 
#define AtFontNORMAL   3 
#define AtFontBIG      4 
#define AtFontBIGGEST  5

typedef struct _AtFontFamily {
    Display *dpy;
    short refcount;
    int num;
    XFontStruct **cache;
    struct _AtFontFamily *next;
} AtFontFamily;

#ifndef P
# ifdef __STDC__
#  define P(args) args
# else
#  define P(args) ()
# endif 
#endif 

extern AtFontFamily *AtFontFamilyGet P((Display *, char *));
extern void AtFontFamilyRelease P((AtFontFamily *));
extern XFontStruct *AtFontFetch P((AtFontFamily *, int, int));
extern int AtFontPointSize P((AtFontFamily *, int));
extern int AtFontPixelSize P((AtFontFamily *, int));
extern int AtFontStringToSize P((char *));
extern void AtRegisterFontSizeConverter P((void));
extern void AtRegisterFontStyleConverter P((void));

extern char *AtFontFamilyGetName P((AtFontFamily *));
#define AtFontFamilyGetDisplay(family) ((family)->dpy)
#define AtFontBigger(size) ((size<AtFontBIGGEST) ? (size+1) : (size))
#define AtFontSmaller(size) ((size>AtFontSMALLEST) ? (size-1) : (size))
#define AtFontEmphasize(face) (face | AtFontBOLD)
#define AtFontDeemphasize(face) (face & ~AtFontBOLD)
#define AtFontItalicize(face) (face | AtFontITALIC)
#define AtFontDeitalicize(face) (face & ~AtFontITALIC)
extern void AtFontSetStyle P((AtFontFamily *, int));

extern int AtFontPSTextWidth P((AtFontFamily *, int, int, char *, int));
extern int AtFontPSAscent P((AtFontFamily *, int, int));
extern int AtFontPSDescent P((AtFontFamily *, int, int));
extern char *AtFontPSName P((AtFontFamily *, int));

/* Resource classes and types for use with the X Toolkit */
#define XtCFontFamily "FontFamily"
#define XtCFontSize   "FontSize"
#define XtCFontStyle  "FontStyle"
#define XtRFontSize   "FontSize"
#define XtRFontStyle  "FontStyle"



#endif
