
/*

________________________________________________________________

        Xfunc.c
        $Id: Xfunc.c,v 1.90 1997/07/29 11:44:53 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

static char *Id = "$Id: Xfunc.c,v 1.90 1997/07/29 11:44:53 svein Exp $, Otto Milvang, Blab, UiO";




#include <xite/includes.h>
#include <xite/biff.h>
#include <ctype.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include "Xfunc.h"
#include <stdlib.h>
#include <X11/StringDefs.h>
#include <xite/message.h>
#include "xshow.h"
#include <xite/debug.h>
#include XITE_UNISTD_H

/* Global external variables. */

extern Widget Control_e;

/* Local external variables. */

static XtAppContext appcon_s;



#ifndef FUNCPROTO
static void ReadImage2(client_data, fid, id)
XtPointer client_data;
int *fid;
XtInputId *id;
#else /* FUNCPROTO */
static void ReadImage2(XtPointer client_data, int *fid, XtInputId *id)
#endif /* FUNCPROTO */
{
  int status, mess;

  ENTER_FUNCTION_DEBUG("Xfunc.c: ReadImage2");

  mess = Iset_message(FALSE);
  status = Read_ipipe(*fid, NULL);
  Iset_message(mess);

  FPRINTF2("    Read_ipipe return: %d.\n", status);

  if (!status) {
    Message(1, "Input job finished - %s\n", "stdin");
    XtRemoveInput(*id);  
    close(*fid);
  }

  LEAVE_FUNCTION_DEBUG("Xfunc.c: ReadImage2");

} /* ReadImage2() */

#ifndef FUNCPROTO
void Open_pipe(pipe, val)
int pipe, val;
#else /* FUNCPROTO */
void Open_pipe(int pipe, int val)
#endif /* FUNCPROTO */
{
  ENTER_FUNCTION_DEBUG("Xfunc.c: Open_pipe");

  if (!appcon_s) appcon_s = XtWidgetToApplicationContext(Control_e);
  XtAppAddInput(appcon_s, pipe, (XtPointer) XtInputReadMask, ReadImage2, NULL);

  LEAVE_FUNCTION_DEBUG("Xfunc.c: Open_pipe");

} /* Open_pipe() */

#ifndef FUNCPROTO
void Main_loop()
#else /* FUNCPROTO */
void Main_loop(void)
#endif /* FUNCPROTO */
{
  ENTER_FUNCTION_DEBUG("Xfunc.c: Main_loop");

  if (!appcon_s) appcon_s = XtWidgetToApplicationContext(Control_e);
  XtAppMainLoop(appcon_s);

  LEAVE_FUNCTION_DEBUG("Xfunc.c: Main_loop");
} /* Main_loop() */
