/*

________________________________________________________________

        XmenuBar.c
        $Id: XmenuBar.c,v 1.6 1997/05/25 11:51:33 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

static char *Id = "$Id";



/*I*

________________________________________________________________

		Include files and definitions
________________________________________________________________

*/

#include <xite/includes.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xfwf/PullDown.h>
#include <Xfwf/MenuBar.h>
#include <xite/debug.h>
#include <xite/XmenuBar.h>

extern Widget colorsmenu_e, overlaysmenu_e, toolsmenu_e, optionsmenu_e,
              visualsmenu_e;

#ifndef FUNCPROTO
static void CreateMenuButtons(parent, buttons)
Widget parent;
menu_button buttons;
#else /* FUNCPROTO */
static void CreateMenuButtons(Widget parent, menu_button buttons)
#endif /* FUNCPROTO */
{
  Widget ColorMenuButton, OverlayMenuButton, ProgMenuButton, FlagMenuButton,
         VisualMenuButton;

  if (buttons & COLORS_BUTTON)
    ColorMenuButton   = XtVaCreateManagedWidget("colors",
						xfwfPullDownWidgetClass,
						parent,
						XtNpopup, colorsmenu_e,
						NULL);
  if (buttons & OVERLAYS_BUTTON)
    OverlayMenuButton = XtVaCreateManagedWidget("overlays",
						xfwfPullDownWidgetClass,
						parent,
						XtNpopup, overlaysmenu_e,
						NULL);
  if (buttons & TOOLS_BUTTON)
    ProgMenuButton    = XtVaCreateManagedWidget("tools",
						xfwfPullDownWidgetClass,
						parent,
						XtNpopup, toolsmenu_e,
						NULL);
  if (buttons & OPTIONS_BUTTON)
    FlagMenuButton    = XtVaCreateManagedWidget("options",
						xfwfPullDownWidgetClass,
						parent,
						XtNpopup, optionsmenu_e,
						NULL);

  if (buttons & VISUALS_BUTTON)
    VisualMenuButton  = XtVaCreateManagedWidget("visuals",
						xfwfPullDownWidgetClass,
						parent,
						XtNpopup, visualsmenu_e,
						NULL);
} /* CreateMenuButtons() */
    
#ifndef FUNCPROTO
Widget CreateMenuBar(parent, buttons)
Widget parent;
menu_button buttons;
#else /* FUNCPROTO */
Widget CreateMenuBar(Widget parent, menu_button buttons)
#endif /* FUNCPROTO */
{
  Widget menu_bar;
  Dimension width;

  XtVaGetValues(parent, XtNwidth, &width, NULL);
  menu_bar = XtVaCreateManagedWidget("menubar",
				     xfwfMenuBarWidgetClass,
				     parent,
				     XtNwidth, width,
				     NULL);
  CreateMenuButtons(menu_bar, buttons);

  return(menu_bar);

} /* CreateMenuBar() */
