/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

/* ARGSUSED */
XtActionProc
SetCurrentWindow(w, event, params, nparams)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal nparams;
{
  xgobi.current_window = 1;
}

/* ARGSUSED */
XtActionProc
UnsetCurrentWindow(w, event, params, nparams)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal nparams;
{
  XCrossingEvent *evnt = (XCrossingEvent *) event;

  if (evnt->detail != NotifyInferior)
    xgobi.current_window = 0;
}

XtActionProc HelpSelect(), Bell();
XtActionProc ShowTarget(), DontShowTarget();
XtActionProc NullNearestPoint();
XtActionsRec added_actions[] = {
  {"HelpSelect", (XtActionProc) HelpSelect},
  {"Bell", (XtActionProc) Bell},
  {"SetCurrentWindow", (XtActionProc) SetCurrentWindow},
  {"UnsetCurrentWindow", (XtActionProc) UnsetCurrentWindow},
  {"ShowTarget", (XtActionProc) ShowTarget},
  {"DontShowTarget", (XtActionProc) DontShowTarget},
  {"NullNearestPoint", (XtActionProc) NullNearestPoint},
};

/*
 * Dummy declarations so the compiler will pass the network
 * section of the code.
*/
/* ARGSUSED */
int
Sread_array_network(d, x)
  char *d;
  xgobidata *x;
{
}
/* ARGSUSED */
int
Sread_collabels_network(d, l, x)
  char *d, *l;
  xgobidata *x;
{
}
/* ARGSUSED */
int
Sread_rowlabels_network(d, l, x)
  char *d, *l;
  xgobidata *x;
{
}

String
fallback_resources[] = {
  "*XGobi.title: XGobi",
  "*XGobi.iconName: XGobi",
  "*font: -*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*",
  /*"*XGobi*font: -*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*",*/
  "*plotFont:   -*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*",
  "*helpFont:   -*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*",
  "*showAxes: True",
  "*showPoints: True",
  "*showLines: False",
  "*linkBrush: True",
  "*linkIdentify: True",
  "*linkTour: True",
  "*carryVars: False",
  "*jumpBrush: True",
  "*reshapeBrush: True",
  "*glyphType: 6",
  "*glyphSize: 1",
  "*brushColor0: Red",
  "*brushColor1: Green",
  "*brushColor2: Yellow",
  "*brushColor3: Orange",
  "*brushColor4: YellowGreen",
  "*brushColor5: HotPink",
  "*brushColor6: SkyBlue",
  "*brushColor7: SlateBlue",
  "*brushColor8: Orchid",
  "*brushColor9: Peru",

  "*XGobi*horizDistance: 5",
  "*XGobi*vertDistance: 5",
  "*XGobi*Options*vertDistance: 2",

  "*XGobi*Form1.gripIndent: 5",
  "*XGobi*MainPanel.defaultDistance: 2",
  "*XGobi*MainPanel.SubPanel.defaultDistance: 2",
  "*XGobi*MainPanel.SubPanel*vertDistance: 2",
  "*XGobi*MainPanel.SubPanel*horizDistance: 2",

  "*XGobi*PlotWindow.height: 320",
  "*XGobi*PlotWindow.width: 320",

  "*XGobi*VarPanel.hSpace: 1",
  "*XGobi*VarPanel.vSpace: 1",
  "*XGobi*VarPanel.borderWidth: 0",
  "*XGobi*VarPanel.width: 180",
  "*XGobi*VarPanel.top: ChainTop",
  "*XGobi*VarPanel.left: ChainLeft",
  "*XGobi*VarPanel.right: ChainRight",
  "*XGobi*VarPanel.bottom: ChainBottom",

  "*XGobi*VarForm.borderWidth: 0",
  "*XGobi*VarForm.hSpace: 0",
  "*XGobi*VarForm.vSpace: 0",
  "*XGobi*VarWindow.borderWidth: 0",
  "*XGobi*VarWindow.width: 44",
  "*XGobi*VarWindow.vertDistance: 0",

  "*XGobi*TourPanel*hSpace: 3",
  "*XGobi*TourPanel*vSpace: 3",
  "*XGobi*TourPanel*vertDistance: 3",
  "*XGobi*TourPanel*horizDistance: 3",
  "*XGobi*TourPanel*Panel.Scrollbar.vertDistance: 0",

  "*XGobi*PPplot.height:  180",
  "*XGobi*PPplot.width:   500",

  "*XGobi*ScaleShiftPanel*hSpace: 3",
  "*XGobi*ScaleShiftPanel*vSpace: 3",
  "*XGobi*ScaleShiftPanel*Icon.horizDistance: 0",
  "*XGobi*ScaleShiftPanel*Icon.vertDistance: 0",

  "*XGobi*StdizePanel*hSpace: 3",
  "*XGobi*StdizePanel*vSpace: 3",
  "*XGobi*StdizePanel*horizDistance: 3",
  "*XGobi*StdizePanel*vertDistance: 3",

  "*XGobi*BrushPanel.Panel.hSpace: 2",
  "*XGobi*BrushPanel.Panel.vSpace: 2",

  "*XGobi*FSavePopup*FSaveName.height: 25",
  "*XGobi*FSavePopup*FSaveName.width: 265",
  "*XGobi*FSavePopup*FSaveText.height: 25",

  "*XGobi*Help*Text.height: 250",
  "*XGobi*Help*Text.width: 600",

  "*XGobi*MouseLabel.left: ChainLeft",
  "*XGobi*MouseLabel.right: ChainLeft",
  "*XGobi*MouseLabel.top: ChainTop",
  "*XGobi*MouseLabel.bottom: ChainTop",
  "*XGobi*MouseLabel.mappedWhenManaged: False",
  "*XGobi*VarMouseLabel.left: ChainLeft",
  "*XGobi*VarMouseLabel.right: ChainLeft",
  "*XGobi*VarMouseLabel.top: ChainTop",
  "*XGobi*VarMouseLabel.bottom: ChainTop",

/* ... if we named each of these widgets,
   we could put the accelerators under user control.
   And save some code.
  "*XGobi*DotPlot.accelerators: <Key>D: set() notify()",
  "*XGobi*XYPlot.accelerators: <Key>X: set() notify()",
*/

  /* Translations */
  "*XGobi*Form0.Translations: #augment \\n\
    <EnterWindow>:  SetCurrentWindow() \\n\
    <LeaveWindow>:  UnsetCurrentWindow()",
  "*XGobi*Subset0.Translations: #augment \\n\
    <EnterWindow>:  SetCurrentWindow() \\n\
    <LeaveWindow>:  UnsetCurrentWindow()",

  "*XGobi*VarPanel.Translations: #augment \\n\
    <EnterWindow>:  ShowTarget() \\n\
    <LeaveWindow>:  DontShowTarget()",

  "*XGobi*Scrollbar.Translations: #override \\n\
    <Btn1Down>:   StartScroll(Continuous) MoveThumb() NotifyThumb() \\n\
    <Btn1Motion>: MoveThumb() NotifyThumb() \\n\
    <Btn3Down>:   HelpSelect()",
  "*XGobi*PrintText.Translations: #override <Key>Return: Bell()",

  "*XGobi*Toggle.Translations: #override \\n\
    <EnterWindow>:         highlight(Always) \\n\
    <LeaveWindow>:         unhighlight() \\n\
    <Btn1Down>, <Btn1Up>:  set()notify() \\n\
    <Btn3Down>:            HelpSelect()",

  "*XGobi*Command.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*MenuButton.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*PlotWindow.Translations: #override \\n\
     <LeaveWindow>:  NullNearestPoint() \\n\
     <Btn3Down>:     HelpSelect()",
  "*XGobi*VarLabel.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*VarWindow.Translations: #override <Btn3Down>: HelpSelect()",
  "*XGobi*Icon.Translations: #override <Btn3Down>: HelpSelect()",

  /* Menu Icon */
  "*XGobi*MenuButton.leftBitmap: menu12",

  /* Colors */

  "*XGobi*background: Moccasin",
  "*XGobi*foreground: NavyBlue",
  "*pointerColor: White",
  "*XGobi*MainPanel.background: DarkKhaki",
  "*XGobi*PlotWindow.background: blue4",
  "*XGobi*PlotWindow.foreground: white",
  "*XGobi*Command.background: SandyBrown",
  "*XGobi*Command.borderColor: NavyBlue",
  "*XGobi*Command.foreground: NavyBlue",
  "*XGobi*Toggle.background: SandyBrown",
  "*XGobi*Toggle.borderColor: NavyBlue",
  "*XGobi*Toggle.foreground: NavyBlue",
  "*XGobi*MenuButton.background: SandyBrown",
  "*XGobi*MenuButton.borderColor: NavyBlue",
  "*XGobi*MenuButton.foreground: NavyBlue",
  "*XGobi*Scrollbar.background: SandyBrown",
  "*XGobi*Scrollbar.borderColor: NavyBlue",
  "*XGobi*Scrollbar.foreground: NavyBlue",
  /*
   * This is ignored; the arrows are created with certain
   * color characteristics.  See make_arrows() in widgets.c.
  "*XGobi*Arrow.background: SandyBrown",
  "*XGobi*Arrow.borderColor: NavyBlue",
  */

  "*XGobi*PPplot.background: Blue4",
  "*XGobi*PPplot.foreground: white",

  "*XGobi*BrushPanel.background: PeachPuff",
  "*XGobi*BrushPanel.Panel.background: DarkKhaki",
  "*XGobi*BrushPanel*Menu*background: NavyBlue",
  "*XGobi*BrushPanel*Menu*borderColor: White",
  "*XGobi*BrushPanel*Menu*foreground: White",
  "*XGobi*Help*background: Gray85",
  "*XGobi*Help*foreground: NavyBlue",
  "*XGobi*Help*Done.background: Moccasin",

  "*XGobi*ScalePanel.background: DarkKhaki",
  "*XGobi*ShiftPanel.background: DarkKhaki",
  "*XGobi*StdizePanel.background: DarkKhaki",

  "*XGobi*SpinPanel.Panel.background: DarkKhaki",
  "*XGobi*SpinPanel.background: PeachPuff",
  "*XGobi*TourPanel*Menu*background: DarkKhaki",
  "*XGobi*TourPanel*Menu*foreground: NavyBlue",
  "*XGobi*TourPanel*Panel.background: DarkKhaki",
  "*XGobi*TourPanel*TourLabel.background: PeachPuff",
  "*XGobi*TourPanel.background: PeachPuff",
  "*XGobi*XYPlotPanel.background: PeachPuff",

  /*"*XGobi*VarPanel.foreground: DarkKhaki",*/
  "*XGobi*VarPanel*VarLabel.background: PeachPuff",
  "*XGobi*VarPanel*VarLabel.foreground: NavyBlue",

  "*XGobi*MouseLabel.background: Salmon",
  "*XGobi*MouseLabel.foreground: NavyBlue",
  "*XGobi*VarMouseLabel.background: Salmon",
  "*XGobi*VarMouseLabel.foreground: NavyBlue",

  NULL,
};

void
XGobiMainLoop(xg)
  xgobidata *xg;
{
  XEvent event;
  Drawable root_window = DefaultRootWindow(display);
  void read_ids(), read_paint(), read_rows_in_plot();
  void read_tour_coefs();

/*
 * Set up to receive Property Change events.
*/
  XSelectInput(display, DefaultRootWindow(display), PropertyChangeMask);

  xg->nevents = 0;
  while (1)
  {
    XtAppNextEvent(app_con, &event);
/*printf("event.type = %d\n", event.type);*/

    if (event.type == PropertyNotify &&
        event.xproperty.window == root_window)
    {
      if (event.xproperty.atom == XG_ROWSINPLOT_ANNC)
      {
        if (!xg->current_window && xg->linked_brushing)
          read_rows_in_plot(xg);
      }
      else if (event.xproperty.atom == XG_NEWPAINT_ANNC)
      {
        if (!xg->current_window && xg->linked_brushing)
        {
          xg->nevents++ ;
          if (xg->nevents == 1)
             read_paint(xg);
        }
      }
      else if (event.xproperty.atom == XG_IDS_ANNC)
      {
        if (!xg->current_window && xg->linked_identify)
          read_ids(xg) ;
      }
      else if (event.xproperty.atom == XG_NEWTOUR_ANNC)
      {
        if (xg->linked_touring && xg->tour_receive && !xg->is_tour_paused)
          read_tour_coefs(xg);
      }
      else
        ;  /* These are the only atoms we are interested in. */
    }
    else
      XtDispatchEvent(&event);
  }
}


