/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
void set_mono();
void help();
void show_message();
/* */

#define MAXNHELP 20
#define NMENUS NCOLS+15

typedef struct {
  Widget hpopup, frame, text, done;
  int helpid;
} HelpData;

typedef struct {
   Widget w;
   char *helpFile;
} HelpTable;

int helpids[MAXNHELP];
HelpTable pb_table[250];
HelpTable sbar_table[10];
HelpTable menupb_table[NMENUS];

/* ARGSUSED */
XtActionProc
HelpSelect(w, evnt, params, nparams)
/*
 * Search the help tables looking for w, then call help()
*/
  Widget w;
  XEvent *evnt;
  String *params;
  Cardinal nparams;
{
  int j = 0;

  while (pb_table[j].w != NULL)
  {
    if (pb_table[j].w == w)
    {
      help(w, pb_table[j].helpFile);
      break;
    }
    else
      j++;
  }

  j = 0;
  while (sbar_table[j].w != NULL)
  {
    if (sbar_table[j].w == w)
    {
      help(w, sbar_table[j].helpFile);
      break;
    }
    else
      j++;
  }

  j = 0;
  while (menupb_table[j].w != NULL)
  {
    if (menupb_table[j].w == w)
    {
      help(w, menupb_table[j].helpFile);
      break;
    }
    else
      j++;
  }
}

/* ARGSUSED */
XtCallbackProc
help_cback(w, client_data, cback_data)
  Widget w;
  caddr_t client_data;
  caddr_t cback_data;
{
  help(w, "Help");
}

void
init_help(xg)
  xgobidata *xg;
{
  int i;

  xg->nhelpids.pb = xg->nhelpids.menupb = xg->nhelpids.sbar = 0;

  for (i=0; i<MAXNHELP; i++)
    helpids[i] = 0;
}

/* ARGSUSED */
XtCallbackProc
help_done_cback(w, dat, cback_data)
  Widget w;
  XtPointer *dat;
  caddr_t cback_data;
{
  HelpData *data = (HelpData *) dat;

  XtDestroyWidget(XtParent(XtParent(w)));
  helpids[data->helpid] = 0;
  XtFree((XtPointer) data);  /* dfschange */
}

void
help(popup_pop, helpfile)
  Widget popup_pop;
  char *helpfile;
{
  int i, ok;
  char fname[100];
  char message[200];
  HelpData *data;
  char *getenv();
  char *xgobidir;
  FILE *fopen();
  extern xgobidata xgobi;

  xgobidir = getenv("XGOBIDIR");
  if (xgobidir == NULL || strlen(xgobidir) == 0)
  {
    xgobidir = (char *) XtMalloc((Cardinal) 100 * sizeof(char));
    (void) strcpy(xgobidir, DEFAULTXGOBIDIR);
    if (xgobidir == NULL || strlen(xgobidir) == 0)
    {
      sprintf(message,
       "XGOBIDIR is not defined in your environment, and\n");
      strcat(message,
       "DEFAULTXGOBIDIR is not defined in the XGobi Makefile;\n");
      strcat(message,
        "see the person who installed XGobi for help.\n");
      show_message(message, &xgobi);
      return;
    }
    else
    {
      (void) strcpy(fname, xgobidir);
      XtFree((XtPointer) xgobidir);
    }
  }
  else
  {
    (void) strcpy(fname, xgobidir);
  }

/*
 * Check that the file is good.
*/
  (void) strcat(fname, "/help/");
  (void) strcat(fname, helpfile);
  if (fopen(fname, "r") == NULL)
  {
    sprintf(message,
      "Unable to open %s.\n", fname);
    strcat(message,
      "Is the shell variable XGOBIDIR the name of the directory\n");
    strcat(message,
      "which contains the help subdirectory?\n");
    show_message(message, &xgobi);
    return;
  }
  else
  {
    ok = 0;
    data = (HelpData *) XtMalloc(sizeof(HelpData));
    for (i=0; i<MAXNHELP; i++)
    {
      if (helpids[i] == 0)
      {
        helpids[i] = 1;
        data->helpid = i;
        ok = 1;
        break;
      }
    }
    if (!ok)
    {
      sprintf(message, "Sorry, can't initiate any more help windows.\n");
      show_message(message, &xgobi);
      return;
    }
  /*
   * Create the popup itself.
  */
    data->hpopup = XtVaCreatePopupShell("Help",
      topLevelShellWidgetClass,
      popup_pop,
      XtNtitle, (String) "XGobi Help Window",
      XtNiconName, (String) "XGobi Help Window",
      NULL);
    if (mono) set_mono(data->hpopup);
  /*
   * Create the paned widget.
  */
    data->frame = XtVaCreateManagedWidget("Form",
      panedWidgetClass, data->hpopup,
      XtNorientation, (XtOrientation) XtorientVertical,
      NULL);
    if (mono) set_mono(data->frame);

  /*
   * Create the text widget.
  */
    data->text = XtVaCreateManagedWidget("Text",
      asciiTextWidgetClass, data->frame,
      XtNallowResize, (Boolean) True,
      XtNshowGrip, (Boolean) False,
      XtNtype, (XawAsciiType) XawAsciiFile,
      XtNstring, (String) fname,
      XtNscrollVertical, (XawTextScrollMode) XawtextScrollWhenNeeded,
      XtNdisplayCaret, (Boolean) False,
      XtNfont, (XFontStruct *) appdata.helpFont,
      NULL);
    if (mono) set_mono(data->text);

  /*
   * Create the Done button.
  */
    data->done = XtVaCreateManagedWidget("Done",
      commandWidgetClass, data->frame,
      XtNshowGrip, (Boolean) False,
      XtNskipAdjust, (Boolean) True,
      XtNlabel, (String) "Click here to dismiss",
      NULL);
    if (mono) set_mono(data->done);

    XtAddCallback(data->done, XtNcallback,
      (XtCallbackProc) help_done_cback, (XtPointer) data);

    XtPopup(data->hpopup, XtGrabNone);
    XRaiseWindow(display, XtWindow(data->hpopup));
  }
  return;
}

void
add_pb_help(n, w, fname)
  int *n;
  Widget w;
  char *fname;
/*
 * Add a widget to the helptable for pushbutton widgets.
*/
{
  if (*n>0 && pb_table[*n-1].w == NULL)
    (*n)--;

  pb_table[*n].w = w;
  pb_table[*n].helpFile = fname;
  (*n)++;
}

void
add_menupb_help(n, w, fname)
  int *n;
  Widget w;
  char *fname;
/*
 * Add a widget to the helptable for pushbutton widgets.
*/
{
  if (*n>0 && pb_table[*n-1].w == NULL)
    (*n)--;

  menupb_table[*n].w = w;
  menupb_table[*n].helpFile = fname;
  (*n)++;
}

void
add_sbar_help(n, w, fname)
  int *n;
  Widget w;
  char *fname;
/*
 * Add a widget to the helptable for scrollbar widgets.
*/
{
  sbar_table[*n].w = w;
  sbar_table[*n].helpFile = fname;
  (*n)++;
}
