/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
int fclose();
int dotplot_varselect(), xy_varselect(), spin_varselect() ;
int tour_varselect();
void assign_points_to_bins();
void convert_ticks(), convert_axes(), convert_ticks();
void init_ticks();
void extend_axes(), build_ticks();
void dotplot_texture_var();
void draw_last_touched();
void exit();
void find_plot_center();
void fname_popup();
void plot_once();
void refresh_vbox();
void set_shift_wrld0();
void world_to_plane(), plane_to_screen();
void show_message();
/* */

/* ARGSUSED */
XtCallbackProc
expose_cback(w, xgobi, callback_data)
/*
 * If the plot window is fully or partially exposed, clear and redraw.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
resize_cback(w, xgobi, callback_data)
/*
 * If the window is resized, recalculate the size of the plot window, and
 * then, if points are plotted, clear and redraw.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  XtVaGetValues(xg->workspace,
    XtNwidth, &xg->plotsize.width,
    XtNheight, &xg->plotsize.height, NULL);

  XFreePixmap(display, xg->pixmap0);
  xg->pixmap0 = XCreatePixmap(display, xg->plot_window,
    xg->plotsize.width,
    xg->plotsize.height,
    depth);
  XFillRectangle(display, xg->pixmap0, clear_GC,
    0, 0,
    xg->plotsize.width,
    xg->plotsize.height);

  xg->max.x = (int) xg->plotsize.width;
  xg->max.y = (int) xg->plotsize.height;
  xg->minxy = MIN(xg->max.x, xg->max.y);
  xg->mid.x = xg->max.x / 2;
  xg->mid.y = xg->max.y / 2;
  set_shift_wrld0(xg);

  find_plot_center(xg);
  plane_to_screen(xg);

  if (xg->is_xyplotting)
  {
    /* set axes using ticks0 */
    convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);

    /*
     * If the user hasn't scaled up the data, then use plot_too_big()
     * to make sure the tick and axis labels will fit in the
     * plot window.
    */
    if (xg->scale.x <= xg->scale0.x && xg->scale.y <= xg->scale0.y)
    {
      while (plot_too_big(xg))
      {
        xg->scale0.x = .97 * xg->scale0.x;
        xg->scale.x = xg->scale0.x;
        xg->scale0.y = .97 * xg->scale0.y;
        xg->scale.y = xg->scale0.y;

        plane_to_screen(xg);
        convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
        convert_axes(&xg->ticks0, xg);
      }
    }

    /* set ticks using current axes */
    convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    extend_axes(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    build_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
  }
  else if (xg->is_dotplotting)
  {
    /* set axes using ticks0 */
    convert_ticks(NULL, xg->dotplot_vars.y,
      &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    /* set ticks using current axes */
    convert_ticks(NULL, xg->dotplot_vars.y,
      &xg->ticks, xg);
    extend_axes(NULL, xg->dotplot_vars.y,
      &xg->ticks, xg);
    build_ticks(NULL, xg->dotplot_vars.y,
      &xg->ticks, xg);
  }
/*
 * This causes the var_panel widget to take on its maximum height whenever
 * there is a resize event.
*/
  XtVaGetValues(xg->workspace, XtNheight, &xg->plotsize.height, NULL);
  XtVaSetValues(xg->var_panel, XtNheight, xg->plotsize.height, NULL);

  if (xg->is_brushing)
    assign_points_to_bins(xg);

/*
 * At this point, the expose callback is executed.
*/
}

/* ARGSUSED */
XtCallbackProc
exit_panel_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
/*
 * When xgobi gets its data from S, only nrows rows are
 * allocated, not the 500 rows at a time that are allocated
 * in the freestanding version.
*/
/*   I'm not sure about all this freeing ...
  int k;
  for (k=0; k<xg->nrows; k++)
    XtFree((XtPointer) xg->raw_data[k]);
  XtFree((XtPointer) xg->raw_data);

  for (k=0; k<xg->ncols; k++)
    XtFree((XtPointer) xg->collab[k]);
  XtFree((XtPointer) xg->collab);
  for (k=0; k<xg->nrows; k++)
    XtFree((XtPointer) xg->rowlab[k]);
  XtFree((XtPointer) xg->rowlab);

  XtFree((XtPointer) xg->vgroup_ids);
  XtFree((XtPointer) xg->varboxw);
  XtFree((XtPointer) xg->varlabw);
  XtFree((XtPointer) xg->vardraww);
  XtFree((XtPointer) xg->varchosen);
  free_arrays(xg);
  free_tour(xg);

  reinit_tour_hist(xg);
  if (xg->fl != NULL)
    XtFree((XtPointer) xg->fl);
  if (xg->curr != NULL)
    XtFree((XtPointer) xg->curr);
  if (xg->hfirst != NULL)
    XtFree((XtPointer) xg->hfirst);

  XFreePixmap(display, xg->pixmap0);
*/
	xg->is_realized = False;
  XtDestroyWidget(xg->shell);
}

/* ARGSUSED */
XtCallbackProc
exit_solo_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  xg->is_realized = False;
  XtDestroyApplicationContext(app_con);
  exit(0);
}

/* ARGSUSED */
XtEventHandler
varselect(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  XButtonEvent *event = (XButtonEvent *) evnt;
  int j, newvar = 0;

  if (event->button == 1 || event->button == 2)
  {
    for (j=0; j<xg->ncols_used; j++)
      if (xg->vardraww[j] == w)
        break;

    if (xg->is_xyplotting)
      newvar = xy_varselect(j, event, xg);

    else if (xg->is_dotplotting)
    {
      newvar = dotplot_varselect(j, event, xg);
      dotplot_texture_var(xg);
    }
    else if (xg->is_spinning)
    {
      newvar = spin_varselect(j, event, xg);
      draw_last_touched(xg);
    }
    else if (xg->is_touring &&
        !xg->is_backtracking &&
        !xg->is_local_scan &&
        !xg->tour_receive)
    {
      newvar = tour_varselect(j, xg);
    }


    if (newvar)
    {
      world_to_plane(xg);
      plane_to_screen(xg);

      if (xg->is_xyplotting)
        init_ticks(&xg->xy_vars, xg);
      else if (xg->is_dotplotting)
        init_ticks(&xg->dotplot_vars, xg);

      /*
       * If brushing, screen coordinates just changed and
       * need to re-bin points before plotting.
      */
      if (xg->is_brushing)
        assign_points_to_bins(xg);

      plot_once(xg);
    }
  }
}

/* ARGSUSED */
XtEventHandler
varexpose(w, xg, evnt, cont)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
  Boolean *cont;
{
  int j;

  for (j=0; j<xg->ncols_used; j++)
    if (xg->vardraww[j] == w)
      break;

  refresh_vbox(xg, j, 0);
}

/* ARGSUSED */
XtCallbackProc
add_axes_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->is_axes = !xg->is_axes;
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
showpoints_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->plot_the_points = !xg->plot_the_points;
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
showlines_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->connect_the_points = !xg->connect_the_points;
  /*
   * Set this to 1 in case there are line colors.
  */
  xg->got_new_paint = True;
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
carry_vars_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->carry_vars = !xg->carry_vars;
}

/* ARGSUSED */
XtCallbackProc
store_resources_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  (void) strcpy(xg->save_type, SAVE_RESOURCES);
  fname_popup(w, xg);
}

#define NAMESIZE 35
#define NRES 8
#define NAMESV(j) (namesv + j*NAMESIZE)
void
store_resources(w, xg)
  Widget w;
  xgobidata *xg;
{
  char *fname, resfile[110];
  int j;
  Dimension pwwidth, pwheight;
  Dimension vpwidth;
  FILE *fopen(), *fp;

  XtVaGetValues(w, XtNstring, &fname, NULL);
  (void) strcpy(resfile, fname);
  (void) strcat(resfile, ".resources");

  XtVaGetValues(xg->var_panel, XtNwidth, &vpwidth, NULL);
  XtVaGetValues(xg->workspace,
    XtNwidth, &pwwidth,
    XtNheight, &pwheight, NULL);

  if (Sprocess)
  {
    char Spath[50];
    long foo;
    char *namesv;
    int nameslen;
    namesv = (char *) XtMalloc((Cardinal) (NRES*NAMESIZE) * sizeof(char));

    (void) strcpy(Spath, Spath0);
    (void) strcat(Spath, resfile);
    if ( (fp = fopen(Spath, "w")) == NULL)
    {
      char message[200];
      sprintf(message, "Failed to open the file '%s' for writing.\n", Spath);
      show_message(message, xg);
    }
    else
    {
      /*
       * "1" indicates that the following is an
       * S data structure of one element.
      */
      (void) fprintf(fp, "%cS data%c", (char) 0 , (char) 1);
      /*
       * "5" indicates that the following is of type
       * character.
      */
      foo = (long) 5;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        fprintf(stderr, "xgobi: error in writing resources\n");

      /*
       * NRES says the following has NRES elements."
      */
      foo = (long) NRES;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        fprintf(stderr, "xgobi: error in writing resources\n");

      nameslen = 0;
      j = 0;
      sprintf(NAMESV(j), "*showAxes: %d", xg->is_axes);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*showPoints: %d", xg->plot_the_points);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*showLines: %d", xg->connect_the_points);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*linkBrush: %d", xg->linked_brushing);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*linkIdentify: %d", xg->linked_identify);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*linkTour: %d", xg->linked_touring);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*carryVars: %d", xg->carry_vars);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*jumpBrush: %d", xg->jump_brush);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*reshapeBrush: %d", xg->reshape_brush);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*XGobi*PlotWindow.height: %d", pwheight);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*XGobi*PlotWindow.width: %d", pwwidth);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;
      j++;
      sprintf(NAMESV(j), "*XGobi*VarPanel.width: %d", vpwidth);
      nameslen = nameslen + strlen(NAMESV(j)) + 1;


      foo = (long) nameslen;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        fprintf(stderr, "error 3 in writing resources\n");

      for (j=0; j<NRES; j++)
        (void) fprintf(fp, "%s%c",  NAMESV(j), (char) 0);
      if (fclose(fp) == EOF)
        fprintf(stderr, "error 4 in writing resources\n");
      XtFree((XtPointer) namesv);
    }

  }
  else   /* if not S, write to ASCII file */
  {
    if ((fp = fopen(resfile, "w")) == NULL)
    {
      char message[200];
      sprintf(message, "Failed to open the file '%s' for writing.\n", resfile);
      show_message(message, xg);
    }
    else
    {
      fprintf(fp, "*showAxes: %d\n", xg->is_axes);
      fprintf(fp, "*showPoints: %d\n", xg->plot_the_points);
      fprintf(fp, "*showLines: %d\n", xg->connect_the_points);
      fprintf(fp, "*linkTour: %d\n", xg->linked_touring);
      fprintf(fp, "*linkIdentify: %d\n", xg->linked_identify);
      fprintf(fp, "*linkBrush: %d\n", xg->linked_brushing);
      fprintf(fp, "*carryVars: %d\n", xg->carry_vars);
      fprintf(fp, "*jumpBrush: %d\n", xg->jump_brush);
      fprintf(fp, "*reshapeBrush: %d\n", xg->reshape_brush);
      fprintf(fp, "*XGobi*PlotWindow.height: %d\n", pwheight);
      fprintf(fp, "*XGobi*PlotWindow.width: %d\n", pwwidth);
      fprintf(fp, "*XGobi*VarPanel.width: %d\n", vpwidth);
      fclose(fp);
    }
  }
}

#undef NAMESIZE
#undef NRES
#undef NAMESV
