/*
 * From command-line to resource database to whereever...
 */

/*
 * map [-verbose] [-background color] [-values val[,...]] \
 *	[-region reg[,clat][,clon][,size]] image [file ...] dir
 */

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include "uderrmsg.h"
#include "udres.h"
#include "udalloc.h"

#ifndef lint
    static char	afsid[]	= "$__Header$";
    static char	rfsid[]	= "$Id: udtest.c,v 1.10 1991/06/28 16:24:38 steve Exp $";
#endif

#define	MAXARG	10
#define	MISS	-999

typedef struct {
    int		argc;
    char	*argv[MAXARG];
}   argument;

typedef struct {
    int		ireg;		/* Region-type (index of reg_abbr array) */
    float	iclat;		/* Center latitude */
    float	iclon;		/* Center longitude */
    int		igrid;		/* Grid type? */
}   Region;

extern char	*udstrdup();

int		verbose;

static char	*reg_abbr[]	= {
    "exit", "us", "ne", "at", "se", "mw", "sp", "nw", "sw", "var", "ind"
};


    static int
chk_arg(string, array, size)
    char	*string;
    char	**array;
    int		size;
{
    int		i;

    for (i = 0; i < size; ++i)
	if (strcmp(string, array[i]) == 0)
	    return i;

    return 0;
}


    static void
parse_substring(string, sepchar, arg)
    char	*string;
    int		sepchar;
    argument	*arg;
{
    char	*buf	= udstrdup(string);
    char	delim[2];
    char	*cp;

    delim[0]	= sepchar;
    delim[1]	= 0;

    arg->argc	= 0;

    for (cp = strtok(buf, delim); 
	cp != NULL;
	cp = strtok((char*)NULL, delim)) {

	assert(arg->argc < MAXARG);

	arg->argv[arg->argc++]	= cp;
    }
}


/*
 * Convert a region specification.
 */

    static int
CvtRegion(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		status	= 1;
    static char	me[]	= "CvtRegion";

    if (mode == UD_MNEMONIC) {
	*(char**)str	= "reg[,clat,clon,[igrid]]";

    } else if (mode == UD_POINTER) {
	*(Region**)bin	= (Region*)str;

    } else if (mode == UD_BIN_SIZE) {
	status	= sizeof(Region);

    } else if (mode == UD_TO_STRING) {
	char	buf[4*16+3+1];
	char	*cp	= buf;
	Region	*region	= (Region*)bin;

	(void)strcpy(cp, reg_abbr[region->ireg]);

	if (region->ireg == 0 || region->ireg == 9) {
	    cp	+= strlen(cp);
	    (void)sprintf(cp, ",%f,%f", region->iclat, region->iclon);
	}

	if (region->igrid != (int)MISS) {
	    cp	+= strlen(cp);
	    (void)sprintf(cp, ",%f", region->igrid);
	}

	*(char**)str	= udstrdup(buf);

    } else if (mode == UD_TO_BINARY) {
	argument	arg;
	Region		region;

	region.ireg	= (int)MISS;
	region.iclat	= (float)MISS;
	region.iclon	= (float)MISS;
	region.igrid	= (int)MISS;

	parse_substring((char*)str, ',', &arg);

	region.ireg	= chk_arg(arg.argv[0], reg_abbr, 
	    sizeof(reg_abbr)/sizeof(reg_abbr[0]));

	if (region.ireg == 0 && arg.argc == 2) {
	    status	&=
		sscanf(arg.argv[0], "%f", &region.iclat) &&
		sscanf(arg.argv[1], "%f", &region.iclon);

	} else if (region.ireg == 0 && arg.argc == 3) {
	    status	&=
		sscanf(arg.argv[0],"%f",&region.iclat) &&
	    	sscanf(arg.argv[1],"%f",&region.iclon) &&
		sscanf(arg.argv[2],"%f",&region.igrid);

	} else if (region.ireg == 9 && arg.argc == 3) {
	    status	&= 
		sscanf(arg.argv[1],"%f",&region.iclat) &&
		sscanf(arg.argv[2],"%f",&region.iclon);

	} else if (region.ireg == 9 && arg.argc == 4) {
	    status	&=
		sscanf(arg.argv[1],"%f",&region.iclat) &&
		sscanf(arg.argv[2],"%f",&region.iclon) &&
		sscanf(arg.argv[3],"%f",&region.igrid);
	}

	if (!status) {
	    udadvise("%s: \"%s\" is an invalid region specification.", me,
		(char*)str);
	} else {
	    if (region.igrid <= 0)
		region.igrid = (int)MISS;

	    if (bin != NULL)
		*(Region*)bin	= region;
	}

    } else {
	status	= 0;
    }

    return status;;
}


main(argc, argv)
    int		argc;
    char	**argv;
{
    int		ExitStatus	= EXIT_SUCCESS;
    char	*fg	= "black";
    Region	region;

    /*
     * Note: The "values" array and the "hour" variable have
     * program-defined, default values.
     */
    static int		DefaultValues[1]	= {MISS};
    static int		*values	= DefaultValues;
    static int		nvalues	= 1;		/* >0 => default value */
    static int		nfiles	= -1;
    static int		nhour	= 1;		/* >0 => default value*/
    static char		**files;
    static char		*hour	= "<default value>";	/* default value */
    static char		*bg	= "white";
    static char		*dir	= NULL;
    static char		*image		= "<unset>";
    static char		*OutFile;
    static float	range[2]	= {(float)MISS, (float)MISS};

    static UdKeyTab KeyTab = {
	{"verbose",	0,	UdBool,		(VOIDP)&verbose},
	{"background",	1,	UdString,	(VOIDP)&bg},
	{"range",	2,	UdFloat,	(VOIDP) range},
	{"current",	1,	UdString,	(VOIDP)&hour,	&nhour},
	{"values",	UDARB,	UdInt,		(VOIDP)&values,	&nvalues},
	{"outfile",	1,	UdOutFile,	(VOIDP)&OutFile, NULL, UDREQ},
	{"region",	1,	CvtRegion},
	NULL
    };

    static UdPosTab PosTab = {
	{"image",	1,	UdString,	(VOIDP)&image},
	{"files",	UDARB,	UdInFile,	(VOIDP)&files,	&nfiles, UDOPT},
	{"dir",		1,	UdOutDir,	(VOIDP)&dir},
	NULL
    };

    if (!udinit(KeyTab, PosTab, &argc, argv, argv[0], (char*)NULL)) {
	ExitStatus	= udreserr() ? EXIT_FAILURE : EXIT_SUCCESS;

    } else {
	(void)udgetval("files", (char*)NULL, UDARB, UdInFile, 
	    (VOIDP)&files, &nfiles);
	(void)udgetval("directory", (char*)NULL, 1, UdOutDir, (VOIDP)&dir,
	    (int*)NULL);
	(void)udgetval("region", (char*)NULL, 1, CvtRegion, (VOIDP)&region,
	    (int*)NULL);
	/*
	 *	The following line causes the SunOS4 lint(1) to generate a 
	 *	warning about "possible pointer alignment problem.  This may 
	 *	safely be ignored.
	 */
	(void)udgetval("foreground", (char*)NULL, 1, UdString, (VOIDP)fg,
	    (int*)NULL);

	if (udreserr()) {
	    udusage();
	    ExitStatus	= EXIT_FAILURE;
	} else {
	    int		i;

	    (void)printf("verbose\t= %d\n", verbose);
	    (void)printf("bg\t= \"%s\"\n", bg);
	    (void)printf("outfile\t= \"%s\"\n", OutFile == NULL 
							    ? "<nil>" 
							    : OutFile);
	    (void)printf("range\t= %f %f\n", range[0], range[1]);
	    (void)printf("nhour\t= %d\n", nhour);
	    if (nhour > 0)
		(void)printf("current\t= \"%s\"\n", hour);
	    (void)printf("nvalues\t= %d\n", nvalues);
	    for (i = 0; i < nvalues; ++i)
		(void)printf("\tvalues[%d]\t= %d\n", i, values[i]);
	    (void)printf("region:\n");
	    (void)printf("\tireg\t= %d\n", region.ireg);
	    (void)printf("\ticlat\t= %f\n", region.iclat);
	    (void)printf("\ticlon\t= %f\n", region.iclon);
	    (void)printf("\tigrid\t= %d\n", region.igrid);
	    (void)printf("image\t= \"%s\"\n", image);
	    (void)printf("nfiles\t= %d\n", nfiles);
	    for (i = 0; i < nfiles; ++i)
		(void)printf("\tfiles[%d]\t= \"%s\"\n", i, files[i]);
	    (void)printf("dir\t= \"%s\"\n", dir);
	}
    }

    return ExitStatus;
}
