/*
 * $Id: limits.h,v 1.1 1991/05/03 13:38:37 steve Exp $
 *
 * <limits.h> header-file for the SunOS 4.1.1 version of the Unidata
 * applications programming environment (UDAPE).
 */

#ifndef UDPOSIX_H_INCLUDED
#   ifdef __GNUC__
#	include "/usr/local/lib/gcc-include/limits.h"
#   else
#	include "/usr//include/limits.h"
#   endif
#else

#   ifndef	UD_LIMITS_H_INCLUDED
#   define	UD_LIMITS_H_INCLUDED

	/*
	 * Include native header-file.
	 */
#       ifdef __GNUC__
#           include "/usr/local/lib/gcc-include/limits.h"
#       else
#           include "/usr//include/limits.h"
#       endif

	/*
	 * Declare/define missing items.
	 */
#       ifdef __GNUC__

	    /*
	     * POSIX Table 2.2
	     */
#           define _POSIX_ARG_MAX	4096
#           define _POSIX_CHILD_MAX	6
#           define _POSIX_LINK_MAX	8
#           define _POSIX_MAX_CANON	255
#           define _POSIX_MAX_INPUT	255
#           define _POSIX_NAME_MAX	14
#           define _POSIX_NGROUPS_MAX	0
#           define _POSIX_OPEN_MAX	16
#           define _POSIX_PATH_MAX	255
#           define _POSIX_PIPE_BUF	512

	    /*
	     * POSIX Table 2.3
	     */
#           define NGROUPS_MAX		16

	    /*
	     * POSIX Table 2.4
	     */
#           define ARG_MAX	_POSIX_ARG_MAX
#           define CHILD_MAX	_POSIX_CHILD_MAX
#           define OPEN_MAX	_POSIX_OPEN_MAX

	    /*
	     * POSIX Table 2.5
	     */
#           define LINK_MAX	_POSIX_LINK_MAX
#           define MAX_CANON	_POSIX_MAX_CANON
#           define MAX_INPUT	_POSIX_MAX_INPUT
#           define NAME_MAX	_POSIX_NAME_MAX
#           define PATH_MAX	_POSIX_PATH_MAX
#           define PIPE_BUF	_POSIX_PIPE_BUF

#       endif	/* __GNUC__ defined above */

#    endif	/* UD_LIMITS_H_INCLUDED undefined above */

#endif	/* UDPOSIX_H_INCLUDED defined above*/
