/*
 * $Id: stdlib.h,v 1.1 1991/11/18 22:33:26 steve Exp $
 *
 * Header-file for the News OS 4.0 version of <stdlib.h>.
 */

#ifndef UDPOSIX_H_INCLUDED
#   include "/usr//include//stdlib.h"
#else

#ifndef UD_STDLIB_H_INCLUDED
#define	UD_STDLIB_H_INCLUDED

/*
 * Include appropriate, system-supplied header-files.
 */
#include <sys/types.h>
#include "/usr//include//stdlib.h"

/*
 * Define/declare missing items.
 */
extern int	abort	PROTO((void));
extern int	abs	PROTO((int j));
extern double	atof	PROTO((const char *nptr));
extern int	atoi	PROTO((const char *nptr));
extern long int	atol	PROTO((const char *nptr));
extern voidp	*bsearch
			PROTO((const void *key, const void *base, size_t nmemb,
			       size_t size,
			       int (*compar)PROTO((const void *, const void *))
			     ));
extern voidp	*calloc	PROTO((size_t nmemb, size_t size));
extern void	exit	PROTO((int status));
extern void	free	PROTO((void *ptr));
extern char	*getenv	PROTO((const char *name));
extern voidp	*malloc	PROTO((size_t size));
extern int	qsort	PROTO((void *base, size_t nmemb, size_t size,
			       int (*compar)PROTO((const void *, const void *))
			     ));
extern int	rand	PROTO((void));
extern voidp	*realloc
			PROTO((void *ptr, size_t size));
extern int	srand	PROTO((unsigned int seed));

#endif	/* UD_STDLIB_H_INCLUDED not defined */

#endif	/* UDPOSIX_H_INCLUDED defined */
