/*
 * $Id: udposix.h,v 1.2 1991/11/20 22:38:31 steve Exp $
 *
 * Header-file for the HPUX 8.05 version of the Unidata POSIX package.
 */

#ifndef UDPOSIX_H_INCLUDED
#define	UDPOSIX_H_INCLUDED

#define	_POSIX_SOURCE
#define _XOPEN_SOURCE

typedef void		*VOIDP;
typedef void		*voidp;
#define	GLUE(a,b)	a##b
#define	MAKESTRING(s)	# s

/*
 * Set NDEBUG according to DEBUG.
 */
#ifdef DEBUG
#   undef NDEBUG
#else
#   define NDEBUG
#endif

typedef	int	bool;
#define	NO	0
#define	YES	1

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#if defined(__STDC__) || defined(__GNUC__) \
    || defined(__cplusplus) || defined(c_plusplus)
#   define	PROTO(a)	a
#else
#   define	PROTO(a)	()
#endif

/*
 *	Compiler-independent, ANSI-C symbols:
 */
#define FREE_ARG	void*			/* argument to free(3) */

#endif	/* UDPOSIX_H_INCLUDED not defined */
