// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        stranslate.h
//
// Purpose:     translation of strings for Harmony scene viewer
//
// Created:     29 Mar 94   Michael Pichler
//
// Changed:     24 Jan 96   Michael Pichler
//
// $Id: stranslate.h,v 1.10 1996/01/30 11:16:45 mpichler Exp $
//
//</file>



#ifndef harmony_scene_stranslate_h
#define harmony_scene_stranslate_h


#include <hyperg/hyperg/language.h>



//<class>
//
// Name:       STranslate
//
// Purpose:    translate strings
//
//
//<class>



extern HgLanguage::Language slanguage;



class STranslate
{
  public:

    enum SStrSym
    {
      AboutSCENEVIEWER,
      AboutVERSIONtemplate,

      AnchBRIGHTNESS,
      AnchBOUNDINGCUBE,
      AnchCOLORCODE,
      AnchCOLOREDGES,

      AnchorDEFAULTDESTINATION,
      AnchorDEFINEDESTINATION,
      AnchorDEFINESOURCE,
      AnchorDELETE,
      AnchorDESELECT,
      AnchorDISPLAY,
      AnchorFOLLOW,
      AnchorNEXT,
//    AnchorSELECTANCHORS,
      AnchorSELECTGROUPS,
      AnchorSELECTOBJECTS,

      AnchorHintACTIVATION,

      ButtonROTATE,
      ButtonSHOWANCHORS,
      ButtonTRANSL,
      ButtonZOOM,

      ColBLACK,
      ColCYAN,
      ColGRAY,
      ColGREEN,
      ColLIGHTGRAY,
      ColMAGENTA,
      ColORANGE,
      ColPURPLE,
      ColREDBROWN,
      ColYELLOW,
      ColWHITE,

      ColorANCHOREDGES,
      ColorANCHORFACES,
      ColorBACKGROUND,
      ColorHEADSUP,
      ColorOTHER,
      ColorVIEWINGLIGHT,

      DemoCAR_VW,
      DemoCLOCKTOWER,
      DemoCORVETTE,
      DemoCUBE,
      DemoENGINE,
      DemoIICMFOYER,
      DemoIICMINST,
      DemoKANDHLEIT,
      DemoROOM,
      DemoWORLD,

      DialogButtonOPEN,
      DialogButtonSAVE,

      DialogStringCOLLISIONDISTANCE,
      DialogStringFILENAME,
      DialogStringNAVSPEEDFACTOR,
      DialogStringOVERWRITEEXISTENTFILE,
      DialogStringROTATIONSPEED,
      DialogStringZOOMSPEED,

      DialogTitleCOLOURCHOOSER,
      DialogTitleNAVIGATIONSETTINGS,
      DialogTitleOPENFILE,
      DialogTitlePARSEROUTPUT,
      DialogTitleSAVEFILE,

      DisplayAALIASING,
      DisplayBOUNDINGBOX,
      DisplayFLATSHADING,
      DisplayHIDDENLINE,
      DisplayINTERACTIVE,
      DisplaySMOOTHSHADING,
      DisplayTEXTURING,
      DisplayTHESAME,
      DisplayWIREFRAME,

      DocumentANNOTATIONS,
      DocumentATTRIBUTES,
      DocumentPARENTS,
      DocumentREFERENCES,
      DocumentTEXTURES,

      FileDEMO,
      FileEDIT,
      FileEXITVIEWER,
      FileEXPORT,
      FileMAIL,
      FileOPEN,
      FilePARSERERRORS,
      FilePRINT,
      FileSAVEAS,
      FileUSABILITYTESTS,

      HARMONY3DVIEWER,
      VRWEBSCENEVIEWER,

      HelpABOUTPRODUCT,
      HelpINDEX,
      HelpOVERVIEW,

      MenuANCHORS,
      MenuCOLOR,
      MenuDOCUMENT,
      MenuFILE,
      MenuHELP,
      MenuNAVIGATE,
      MenuOPTIONS,
      MenuSPECIAL,
      MenuVIEW,
      MenuVIEWPOINTS,

      MessageERRORNOINPUTFILE,
      MessageERRORONREADING,
      MessageERRORONWRITING,
      MessageSUCCESSFULLYWRITTEN,
      MsgboxtitleERROR,

      NavFLIPOBJECT,
      NavFLY,
      NavFLYTO,
      NavHEADSUP,
      NavWALK,

      NavHintFLIPOBJECT,
      NavHintFLY,
      NavHintFLYTO,
      NavHintFLYTOINHU,
      NavHintHEADSUP,
      NavHintWALK,

      NavigateBACK,
      NavigateFORWARD,
      NavigateHISTORY,
      NavigateHOLD,
      NavigateLEVELVIEW,
      NavigateRESETVIEW,
      NavigateUNTILTVIEW,
      NavigateVIEWPOINT,
      NavigateSETTINGS,
      NavigateSPACEBALL,

      OptionARBITRARYROTATIONS,
      OptionCOLLISIONDETECTION,
      OptionDOLIGHTING,
      OptionENABLEMOTION,
      OptionSHOWFRAMERATE,
      OptionSHOWTITLE,
      OptionTEXTURELIGHTING,
      OptionTWOSIDEDPOLYS,
      OptionVELOCITYCONTROL,

      ProgressPROCESSCAMERAS,
      ProgressREADINGACTORS,
      ProgressREADINGCAMERAS,
      ProgressREADINGLIGHTS,
      ProgressREADINGMATERIALS,
      ProgressREADINGOBJECTS,
      ProgressREADINGPOSITIONS,
      ProgressREADINGTEXTURE,
      ProgressREADINGVRML,
      ProgressREADY,
      ProgressREQUESTINLINEVRML,
      ProgressREQUESTTEXTURE,

      SpaceballDECREASE,
      SpaceballINCREASE,
      SpaceballRESETSENSITIVITY,
      SpaceballREZERO,
      SpaceballROTATION,
      SpaceballSENSITIVITY,
      SpaceballSINGLEAXISFILTER,
      SpaceballTRANSLATION,

      StatuslineFPS,
      StatuslineLASTFRAME,
      StatuslinePOLYGONS,
      StatuslinePRIMITIVES,

      SpecialCAMERAINFO,
      SpecialPRINTALL,
      SpecialPRINTDATA,

      TwosidedAUTO,
      TwosidedOFF,
      TwosidedON,

      UTestEAST,
      UTestNORTH,
      UTestSOUTH,
      UTestWEST,

      NumStrings  // number of defined strings
    };

    static const char* str(             // get a string
      SStrSym strsym,                    //   symbolic string constant
      HgLanguage::Language language = slanguage  // language
                                        //   default: global language
    );
};


#endif
