// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// File:        fchooser.h - interface to file chooser
//
// Created:      1 Jul 94   Michael Pichler
//
// Changed:      7 Nov 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_fchooser_h
#define harmony_widgets_fchooser_h


#include <InterViews/dialog.h>
class WidgetKit;
#include <OS/enter-scope.h>
class String;

class FieldEditor31;
class WFileChooserImpl;
class WFileChooserAction;


// File Chooser Dialog

class WFileChooser: public Dialog
{
  public:
    WFileChooser(                       // file chooser dialog
      const char* dir,                  //   start directory
      WidgetKit*,                       //   kit
      Style*,                           //   style
      WFileChooserAction* = nil,        //   action
      const char* filefilter = 0        //   file name filter (e.g. "*.xxx")
    );
    virtual ~WFileChooser();

    virtual const char* selected() const;    // selection string
    virtual void reread();              // rescan directory

    void rebuild();                     // rebuild dialog

    FieldEditor31* editorField() const; // file name field
    InputHandler* fileBrowser() const;  // file browser (for focus management)
    Glyph* browserGlyph() const;        // file browser with scroll bar

    // Dialog
    virtual void dismiss(boolean);      // close dialog

  private:
    WFileChooserImpl* impl_;
};


class WFileChooserAction: public Resource
{
  protected:
    WFileChooserAction();
    virtual ~WFileChooserAction();

  public:
    virtual void execute(WFileChooser*, boolean accept);
};


// WFileChooserCallback
// callback action for WFileChooser - preprocessor template
// lass declaration and implementation for class T are generated
// with declareWFileChooserCallback(T) and implementWFileChooserCallback(T)

#if defined(__STDC__) || defined(__ANSI_CPP__)
#define WFileChooserCallback(T) T##_WFileChooserCallback
#define WFileChooserMemberFunction(T) T##_WFileChooserMemberFunction
#else
#define WFileChooserCallback(T) T/**/_WFileChooserCallback
#define WFileChooserMemberFunction(T) T/**/_WFileChooserMemberFunction
#endif


#define declareWFileChooserCallback(T) \
typedef void (T::*WFileChooserMemberFunction(T))(WFileChooser*, boolean); \
class WFileChooserCallback(T) : public WFileChooserAction { \
public: \
    WFileChooserCallback(T)(T*, WFileChooserMemberFunction(T)); \
    virtual ~WFileChooserCallback(T)(); \
\
    virtual void execute(WFileChooser*, boolean accept); \
private: \
    T* obj_; \
    WFileChooserMemberFunction(T) func_; \
};


#define implementWFileChooserCallback(T) \
WFileChooserCallback(T)::WFileChooserCallback(T)( \
    T* obj, WFileChooserMemberFunction(T) func \
) { \
    obj_ = obj; \
    func_ = func; \
} \
\
WFileChooserCallback(T)::~WFileChooserCallback(T)() { } \
\
void WFileChooserCallback(T)::execute(WFileChooser* f, boolean accept) { \
    WFileChooserMemberFunction(T) pf = func_; \
    (obj_->*pf)(f, accept); \
}


#endif
