// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        socket.h
// 
// Purpose:     
// 
// Created:     4 May 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_dc_common_socket_h
#define hg_dc_common_socket_h

#include "file.h"

#include "smartptr.h"


struct sockaddr ;
class SocketPtr ;


// <class> 
//  
// Name:             Socket
// 
// Purpose:          
// 
// base class for every kind of socket file number encapsulating class.
// implements generic socket operations (to be extended (?)).
// 
// Public Interface: 
// 
// - boolean blocking() const
//   is my socket file descriptor designated as blocking ?
// - boolean blocking (boolean)
//   set my socket file descriptor (non)blocking
// - boolean accept (int& fd)
//   accept a connection onto fd.
//   note: this will only work if I am listening (see derived classes)
// 
// Description:      hmmm
// 
// </class> 
class Socket : public File {
public:
   Socket() ;
   Socket (int fd, boolean close) ;

   virtual boolean close() ;
   void attach (int fd, boolean close) ;

   boolean blocking() const { return blocking_; }
   boolean blocking (boolean) ;

   boolean listening() const { return get_listening_(); }

   boolean accept (int& fd) ;
   boolean accept (SocketPtr&) ;

protected:
   void set_listening_(boolean b) { listening_ = b; }
   boolean get_listening_() const { return listening_; }

   // just wrapped around the system accept()
   int accept_(struct sockaddr*, int* addrlen) ;

private:
   boolean blocking_ ;
   boolean listening_ ;

   static boolean check_blocking_(int fd) ;
   static boolean set_blocking_(int fd, boolean) ;

private:
   Socket (const Socket&) {}
   Socket& operator = (const Socket&) { return *this; }
} ;

SmartPtrdeclare (SocketPtr, Socket) 


#endif
