/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                      File: MOTIF_oco_modify_volume_color
 *                    Author: Lisa Sobierajski
 *                      Date: 07/9/93
 *               Description: Motif Windowing Routines For Modifying
 *			      Volume Color.
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <X11/StringDefs.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_oco.h"
#include "C_help.h"


/*
 *              Procedure Name: oco_modify_volume_color_callback
 *              Return Value:   none
 *              Input Variables:
 *                      w                - the wiget the callback is made from
 *                      volume_index     - an int which is the index into
 *                                         world.volume[volume_index]
 *                      call_data        - This is needed because this is a
 *                                         call back it is not used at all.
 *
 *              Description:
 *                      This code first makes sure that the object that the
 *                      user wishes to modify does not already have a modify
 *                      color window open.  If it does not, then it goes on
 *                      to open the window.
 */
void oco_modify_volume_color_callback(w, volume_index, call_data )
Widget                  w;
int                     volume_index;
XtPointer               call_data;
{
	extern C_ObjectControlInfo	oco_info;
	extern C_World			world;

	void 				oco_create_volume_modify_color();

	OcoVolumeInfo			*vinfo;

	vinfo = oco_info.volume_info[volume_index];

	if (!vinfo->color.volume_color_displayed)

        {
		oco_create_volume_modify_color(volume_index);
	}
        else
        {
                if (XtIsManaged(
                    vinfo->color.volume_color_displayed ) )
                        XtUnmanageChild(
                                vinfo->color.volume_color_displayed );
                XtManageChild( vinfo->color.volume_color_displayed );
	}
}	


/*
 *              Procedure Name: oco_create_volume_modify_color
 *              Return Value:   none
 *              Input Variables:
 *                      volume_index     - an int which is the index into
 *                                        world.volume[volume_index]
 *
 *              Description:
 *                      In this procedure a pop up is created which contains
 *                      the name of the object, and a option menu (which allows
 *                      the user to select the color model they want to use).
 *                      When a selection is made on the menu, the window is
 *                      changed so that the new paramaters can be altered.
 *			note: the color models are:
 *				single shade - one color for the whole object
 *				color array  - a diffrent value for each 
 *					       voxel value
 */
void oco_create_volume_modify_color(volume_index)
int volume_index;
{
	extern C_ObjectControlInfo	oco_info;
	extern C_World			world;
	extern C_WindowDefs		window_defs;
	extern Widget			vv_toplevel;

	extern C_ColorSelectInfo	*C_create_color_selection();
	extern void			oco_color_array_expose();
	extern void			oco_color_array_input();
	extern void 			close_callback();
	extern void 			help_callback();

	
	void oco_set_color_modified(); 
        void oco_set_volume_color();
        void oco_reset_volume_color();
	void oco_update_color_type();
	void oco_color_function_toggle_callback();

        Arg             args[20];
        int             n;
	char		title_string[256];

        Widget  	frame,
			pulldown,
        		label,
			rowcolumn,
			button,
			bboard,
			menu,
			toggle,
			radiobox;
	XmString        label_string;
	C_Color 	*volume_color;	
	OcoVolumeInfo	*vinfo;
	int		i;
	C_Volume	*volume;
        XColor          color;
        int             pixel;


	vinfo = oco_info.volume_info[volume_index];
	volume = world.volume[volume_index];


        n=0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	sprintf( title_string, "Modify %s Color", 
			world.volume[volume_index]->volume_name );
	XtSetArg( args[n], XmNdialogTitle, XmStringCreate( title_string,
			XmSTRING_DEFAULT_CHARSET) ); n++;	
        C_Set_Color_Dialog( args, n, window_defs );
        vinfo->color.volume_color_displayed =
			XmCreateBulletinBoardDialog(vv_toplevel,
                        	"modify_volume_color", args, n );


        n = 0;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame =
                XmCreateFrame(vinfo->color.volume_color_displayed, 
				"frame", args, n);
        XtManageChild (frame);

        n = 0;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Bboard( args, n, window_defs );
        bboard =
                XmCreateBulletinBoard(frame, 
				"bboard", args, n);
        XtManageChild (bboard);

        n = 0;
        C_Set_Color_PullDown( args, n, window_defs );
        pulldown =
                XmCreatePulldownMenu( bboard, "pulldown", args, n);
        n = 0;
        label_string = XmStringCreate ("Single Color",XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        vinfo->color.color_type[C_SINGLE_COLOR] =
                XmCreatePushButtonGadget(pulldown, "single_color", args, n);
        XtManageChild (vinfo->color.color_type[C_SINGLE_COLOR]);
        XtAddCallback (vinfo->color.color_type[C_SINGLE_COLOR],
                       XmNactivateCallback,
                       oco_update_color_type, volume_index);
 

        n = 0;
        label_string = XmStringCreate ("Color Array",XmSTRING_DEFAULT_CHARSET);
	XtSetArg (args[n], XmNlabelString, label_string); n++;
        vinfo->color.color_type[C_COLOR_ARRAY] =
                XmCreatePushButtonGadget(pulldown, "color_array", args, n);
        XtManageChild (vinfo->color.color_type[C_COLOR_ARRAY]);
        XtAddCallback (vinfo->color.color_type[C_COLOR_ARRAY],
                       XmNactivateCallback,
                       oco_update_color_type, volume_index);

        n = 0;
        label_string = XmStringCreate ("Texture Color",XmSTRING_DEFAULT_CHARSET);
	XtSetArg (args[n], XmNlabelString, label_string); n++;
	XtSetArg (args[n], XmNsensitive, False); n++;
        vinfo->color.color_type[C_TEXTURE_COLOR] =
                XmCreatePushButtonGadget(pulldown, "color_array", args, n);
        XtManageChild (vinfo->color.color_type[C_TEXTURE_COLOR]);
        XtAddCallback (vinfo->color.color_type[C_TEXTURE_COLOR],
                       XmNactivateCallback,
                       oco_update_color_type, volume_index);
        n = 0;
        label_string = XmStringCreate ("Color Type:",
                                      XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg (args[n], XmNsubMenuId, pulldown); n++;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg (args[n], XmNmenuHistory, vinfo->color.color_type[
			world.volume[volume_index]->color_type ]); n++;
        C_Set_Color_OptionMenu( args, n, window_defs );

        menu = XmCreateOptionMenu( bboard,
                                "oco_option_menu", args, n);

        XtManageChild(menu);


        n = 0;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        vinfo->color.bottom_buttons_frame =
                XmCreateFrame( vinfo->color.volume_color_displayed,
                                         "frame", args, n);
        XtManageChild (vinfo->color.bottom_buttons_frame);

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn =
                XmCreateRowColumn( vinfo->color.bottom_buttons_frame,
                                         "rowcolumn", args, n);
        XtManageChild (rowcolumn);
        

	n = 0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget("Accept",
                        xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       oco_set_volume_color, volume_index);

        n = 0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget("Cancel",
                        xmPushButtonWidgetClass, rowcolumn, args, n );

        XtAddCallback( button, XmNactivateCallback,
                       oco_reset_volume_color,volume_index );

        n=0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
                  close_callback, vinfo->color.volume_color_displayed);

        n = 0;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget("Help",
                        xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
                  help_callback, C_OCO_MODIFY_VOLUME_COLOR_HELP );



	/****************************************************************/
	/*								*/
	/*	Create the frame for the single color color type, 	*/
	/*	and create the widgets contained in that frame.		*
	/*								*/
	/****************************************************************/

        volume_color = world.volume[volume_index]->color_data.single_color;

        vinfo->color.volume_color_selector = 
			C_create_color_selection(
                                 bboard,
                                 0, 50,
                                 "Volume Color:", "",
                                 volume_color);

	XtAddCallback( vinfo->color.volume_color_selector->red_slider,
		       XmNvalueChangedCallback, oco_set_color_modified, 
		       volume_index );

	XtAddCallback( vinfo->color.volume_color_selector->green_slider,
		       XmNvalueChangedCallback, oco_set_color_modified, 
		       volume_index );

	XtAddCallback( vinfo->color.volume_color_selector->blue_slider,
		       XmNvalueChangedCallback, oco_set_color_modified, 
		       volume_index );

        vinfo->color.single_color_frame = 
			vinfo->color.volume_color_selector->frame; 
	XtUnmanageChild( vinfo->color.single_color_frame );

	
	/****************************************************************/
	/*								*/
	/*	Create the frame for the color array color type, 	*/
	/*	and create the widgets contained in that frame.		*
	/*								*/
	/****************************************************************/

	if ( !vinfo->data.volume_data_displayed )
	{
	  for (i = 0; i < 256; i++)
          {
            vinfo->color.color_array_red[i] =
               volume->color_data.color_array->color[i].red;
            vinfo->color.color_array_green[i] =
               volume->color_data.color_array->color[i].green;
            vinfo->color.color_array_blue[i] =
               volume->color_data.color_array->color[i].blue;
          }
	}

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 50 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        vinfo->color.color_array_frame =
                        XmCreateFrame(bboard, "frame", args, n );

        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bboard =
                XmCreateBulletinBoard(vinfo->color.color_array_frame,
                                      "bboard", args, n);
        XtManageChild( bboard );

        label_string = XmStringCreate("Edit Function: ",
                        XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, 20 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, "label",
                                                args, n );
        XtManageChild( label );
        XmStringFree( label_string );
 
        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RadioBox( args, n, window_defs );
        XtSetArg( args[n], XmNx, 150 ); n++;
        XtSetArg( args[n], XmNy, 10 ); n++;
        radiobox = XmCreateRadioBox( bboard, "radiobox", args, n );
        XtManageChild( radiobox );
 
 
        n = 0;
        label_string = XmStringCreate ("R", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg( args[n], XmNset, TRUE );
        n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        vinfo->color.color_array_edit_toggle[C_RED_COLOR_EDIT] = 
			XtCreateWidget ("R", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XtManageChild( 
		vinfo->color.color_array_edit_toggle[C_RED_COLOR_EDIT] );
        XmStringFree (label_string);
        XtAddCallback (vinfo->color.color_array_edit_toggle[C_RED_COLOR_EDIT], 
		       XmNvalueChangedCallback,
                       oco_color_function_toggle_callback, volume_index);
 
        n = 0;
        label_string = XmStringCreate ("G", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg( args[n], XmNset, FALSE );
        n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        vinfo->color.color_array_edit_toggle[C_GREEN_COLOR_EDIT] = 
			XtCreateWidget ("G", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XtManageChild( 
		vinfo->color.color_array_edit_toggle[C_GREEN_COLOR_EDIT] );
        XmStringFree (label_string);
        XtAddCallback (vinfo->color.color_array_edit_toggle[C_GREEN_COLOR_EDIT], 
		       XmNvalueChangedCallback,
                       oco_color_function_toggle_callback, volume_index);
 
        n = 0;
        label_string = XmStringCreate ("B", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, label_string); n++;
        XtSetArg( args[n], XmNset, FALSE );
        n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        vinfo->color.color_array_edit_toggle[C_BLUE_COLOR_EDIT] = 
			XtCreateWidget ("B", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XtManageChild( 
		vinfo->color.color_array_edit_toggle[C_BLUE_COLOR_EDIT] );
        XmStringFree (label_string);
        XtAddCallback (vinfo->color.color_array_edit_toggle[C_BLUE_COLOR_EDIT], 
		       XmNvalueChangedCallback,
                       oco_color_function_toggle_callback, volume_index);
 
 

        label_string = XmStringCreate("X Location:",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 70 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( label );
        XmStringFree( label_string );
 
        label_string = XmStringCreate("---",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 100 ); n++;
        XtSetArg( args[n], XmNy, 70 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        vinfo->color.color_array_x_label =
                        XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( vinfo->color.color_array_x_label );
        XmStringFree( label_string );
 
        label_string = XmStringCreate("Y Location:",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 145 ); n++;
        XtSetArg( args[n], XmNy, 70 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( label );
        XmStringFree( label_string );
 
        label_string = XmStringCreate("----",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 235 ); n++;
        XtSetArg( args[n], XmNy, 70 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        vinfo->color.color_array_y_label =
                        XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( vinfo->color.color_array_y_label );
        XmStringFree( label_string );
 
 
        label_string = XmStringCreate("R: ",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 5 ); n++;
        XtSetArg( args[n], XmNy, 90 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( label );
        XmStringFree( label_string );
 
        label_string = XmStringCreate("----",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 35 ); n++;
        XtSetArg( args[n], XmNy, 90 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        vinfo->color.color_array_r_label =
                        XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( vinfo->color.color_array_r_label );
        XmStringFree( label_string );
 

        label_string = XmStringCreate("G: ",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 105 ); n++;
        XtSetArg( args[n], XmNy, 90 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( label );
        XmStringFree( label_string );
 
        label_string = XmStringCreate("----",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 135 ); n++;
        XtSetArg( args[n], XmNy, 90 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        vinfo->color.color_array_g_label =
                        XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( vinfo->color.color_array_g_label );
        XmStringFree( label_string );
 
 

        label_string = XmStringCreate("B: ",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 205 ); n++;
        XtSetArg( args[n], XmNy, 90 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( label );
        XmStringFree( label_string );
 
        label_string = XmStringCreate("----",
                              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 235 ); n++;
        XtSetArg( args[n], XmNy, 90 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        vinfo->color.color_array_b_label =
                        XmCreateLabelGadget( bboard, "label", args, n );
        XtManageChild( vinfo->color.color_array_b_label );
        XmStringFree( label_string );
 
 
 
        color.red = 0;
        color.green = 0;
        color.blue = 0;
        
        if ( window_defs.depth == 24 )
                pixel = C_Get_Pixel( color );
        else
                pixel = window_defs.first_color_index;
 
        n = 0;
        XtSetArg( args[n], XmNwidth, 256 ); n++;
        XtSetArg( args[n], XmNheight, 286 ); n++;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 120 ); n++;
        XtSetArg( args[n], XmNbackground, pixel ); n++;
        vinfo->color.color_array_draw_area =
                XmCreateDrawingArea( bboard, "draw_area", args, n );
 
        XtManageChild( vinfo->color.color_array_draw_area );


        XtAddCallback( vinfo->color.color_array_draw_area, XmNexposeCallback,
                       oco_color_array_expose, volume_index );
 
        XtAddEventHandler( vinfo->color.color_array_draw_area,
                           ButtonPressMask | ButtonReleaseMask |
                           PointerMotionMask, False,
                           oco_color_array_input, volume_index );

 
        vinfo->color.color_array_gc = NULL;
 
        XtManageChild( vinfo->color.volume_color_displayed );

	switch ( world.volume[volume_index]->color_type )
	{
	    case C_SINGLE_COLOR:
		XtManageChild( vinfo->color.single_color_frame );
		oco_update_color_type( vinfo->color.color_type[C_SINGLE_COLOR],
				       volume_index, NULL );
		break;
	    case C_COLOR_ARRAY:
		XtManageChild( vinfo->color.color_array_frame );
		oco_update_color_type( vinfo->color.color_type[C_COLOR_ARRAY],
				       volume_index, NULL );
		break;
	    case C_TEXTURE_COLOR:
		oco_update_color_type( vinfo->color.color_type[C_TEXTURE_COLOR],
				       volume_index, NULL );
		break;
	}


}

void oco_color_function_toggle_callback( w, volume_index, call_data )
Widget                          w;
int                     	volume_index;
XmToggleButtonCallbackStruct    *call_data;
{
	extern C_ObjectControlInfo	oco_info;

	OcoVolumeInfo			*vinfo;

	if ( call_data->set )
	{
		vinfo = oco_info.volume_info[volume_index];
		if ( w == 
		     vinfo->color.color_array_edit_toggle[C_RED_COLOR_EDIT] )
			vinfo->color.color_array_edit_type = 
					C_RED_COLOR_EDIT;
		else if ( w == 
		     vinfo->color.color_array_edit_toggle[C_GREEN_COLOR_EDIT] )
			vinfo->color.color_array_edit_type = 
					C_GREEN_COLOR_EDIT;
		else if ( w == 
		     vinfo->color.color_array_edit_toggle[C_BLUE_COLOR_EDIT] )
			vinfo->color.color_array_edit_type = 
					C_BLUE_COLOR_EDIT;
	}
}
 


void oco_update_color_type( w, volume_index, call_data )
Widget          w;
int	        volume_index;
XtPointer       call_data;
{
	extern void oco_update_seg_type();

        extern C_ObjectControlInfo      oco_info;
	extern C_World			world;
 
        Dimension       y_val;
        Dimension       height;
        Arg             args[2];
	OcoVolumeInfo	*vinfo;

	vinfo = oco_info.volume_info[volume_index];
 
        if ( w == vinfo->color.color_type[C_SINGLE_COLOR] )
		world.volume[volume_index]->color_type = 
                          vinfo->color.curr_color_type = C_SINGLE_COLOR;
        else if ( w == vinfo->color.color_type[C_COLOR_ARRAY] )
		world.volume[volume_index]->color_type = 
                          vinfo->color.curr_color_type = C_COLOR_ARRAY;
 
        if ( XtIsManaged( vinfo->color.single_color_frame ) )
                XtUnmanageChild( vinfo->color.single_color_frame );
 
        if ( XtIsManaged( vinfo->color.color_array_frame ) )
                XtUnmanageChild( vinfo->color.color_array_frame );
 
        XtSetArg( args[0], XmNy, &y_val );
        XtSetArg( args[1], XmNheight, &height );
 
        switch ( vinfo->color.curr_color_type )
        {
            case C_SINGLE_COLOR:
                XtManageChild( vinfo->color.single_color_frame );
                XtGetValues( vinfo->color.single_color_frame, args, 2 );
                break;
            case C_COLOR_ARRAY:
                XtManageChild( vinfo->color.color_array_frame );
                XtGetValues( vinfo->color.color_array_frame, args, 2 );
                break;
	    case C_TEXTURE_COLOR:
		y_val = 60;
		height = 20;
		break;
        }
        XtSetArg( args[0], XmNy, y_val + height + 40 );
        XtSetValues( vinfo->color.bottom_buttons_frame, args, 1 );
 
	oco_update_seg_type( NULL, vinfo->data.seg_info, NULL );
 
}



/*
 *              Procedure Name: oco_set_volume_color
 *              Return Value:   none
 *              Input Variables:
 *                      w                - the wiget the callback is made from
 *                      volume_index     - an int which is the index into
 *                                         world.volume[volume_index]
 *                      call_data        - This is needed because this is a
 *                                         call back it is not used at all.
 *
 *              Description:
 *                      The code herein updates the color model data for the
 *                      object when the accept button is pressed.  If there is
 *                      an error in the input, the source of the error will be
 *                      reported to the message window, and no update will be
 *                      made (at this time there is no way for an error to 
 *			appear in the input).
 *
 *                      NOTE: the only values that are altered are the values
 *                      of the present color model. ie, only the values seen
 *                      on the screen at the time that the accept is hit are
 *                      updated.
 */

void oco_set_volume_color( w,volume_index, call_data )
Widget                  w;
int                     volume_index;
XtPointer               call_data;
{
	extern void			C_update_system();

	extern C_ObjectControlInfo	oco_info;
	extern C_World			world;

	OcoVolumeInfo			*vinfo;
	int             		tmp_val;
	int				i;
	C_Volume			*volume;
	char				string[256];
	Arg				args[1];	

	vinfo = oco_info.volume_info[volume_index];
	volume = world.volume[volume_index];


	if(vinfo->color.curr_color_type == C_SINGLE_COLOR)
        {
	
        	XmScaleGetValue( vinfo->color.volume_color_selector->
               	          	 red_slider, &tmp_val);
        	volume->color_data.single_color->red = tmp_val;
        	XmScaleGetValue( vinfo->color.volume_color_selector->
               		         green_slider, &tmp_val);
        	volume->color_data.single_color->green = tmp_val;
        	XmScaleGetValue( vinfo->color.volume_color_selector->
                        	 blue_slider, &tmp_val);
        	volume->color_data.single_color->blue = tmp_val;

		volume->color_type = C_SINGLE_COLOR;
	}
	 else if (vinfo->color.curr_color_type == C_COLOR_ARRAY)
        {
		for ( i = 0; i < 256; i++ )
		{
			volume->color_data.color_array->color[i].red = 
				vinfo->color.color_array_red[i];
			volume->color_data.color_array->color[i].green = 
				vinfo->color.color_array_green[i];
			volume->color_data.color_array->color[i].blue = 
				vinfo->color.color_array_blue[i];
		}

		volume->color_type = C_COLOR_ARRAY;
	}

        sprintf( string, "Modify %s Color",
                world.volume[volume_index]->volume_name );
        XtSetArg( args[0], XmNdialogTitle, 
                XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
        XtSetValues( vinfo->color.volume_color_displayed, args, 1 );
 
	C_update_system( C_VOLUME_COLOR_MODIFIED );

}

/*
 *              Procedure Name: oco_reset_volume_color
 *              Return Value:   none
 *              Input Variables:
 *                      w                - the wiget the callback is made from
 *                      volume_index     - an int which is the index into
 *                                         world.volume[volume_index]
 *                      call_data        - This is needed because this is a
 *                                         call back it is not used at all.
 *
 *              Description:
 *                      The code herein resets the color model widgets for
 *                      object when the cancel button is pressed.
 */
void oco_reset_volume_color(w, volume_index, call_data )
Widget                  w;
int                     volume_index;
XtPointer               call_data;
{

	extern void			C_update_system();
	extern void			oco_draw_color_array();

	extern C_ObjectControlInfo	oco_info;
	extern C_World			world;

	OcoVolumeInfo			*vinfo;
	int             		tmp_val;
	int				i;
	C_Volume			*volume;
	char				string[256];
	Arg				args[1];	

	vinfo = oco_info.volume_info[volume_index];
	volume = world.volume[volume_index];

	vinfo->color.curr_color_type = volume->color_type;

       	XmScaleSetValue( vinfo->color.volume_color_selector->red_slider, 
        		 volume->color_data.single_color->red );
       	XmScaleSetValue( vinfo->color.volume_color_selector->green_slider,
        		 volume->color_data.single_color->green );
       	XmScaleSetValue( vinfo->color.volume_color_selector->blue_slider,
        	     	 volume->color_data.single_color->blue );
	     
	C_change_color(  vinfo->color.volume_color_selector->red_slider,
			  vinfo->color.volume_color_selector, NULL );

	for ( i = 0; i < 256; i++ )
	{
		vinfo->color.color_array_red[i] =
		    volume->color_data.color_array->color[i].red; 
		vinfo->color.color_array_green[i] =
		    volume->color_data.color_array->color[i].green; 
		vinfo->color.color_array_blue[i] =
		    volume->color_data.color_array->color[i].blue; 
	}


        sprintf( string, "Modify %s Color", volume->volume_name );
        XtSetArg( args[0], XmNdialogTitle, 
                XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
        XtSetValues( vinfo->color.volume_color_displayed, args, 1 );
 

	oco_draw_color_array( volume_index, 0, 255 );
	oco_draw_s_opacity( vinfo->data.seg_info, 0, 255 );

}

void oco_set_color_modified(w, volume_index, call_data )
Widget                  w;
int                     volume_index;
XtPointer               call_data;
{
	extern C_ObjectControlInfo	oco_info;
	extern C_World			world;

	OcoVolumeInfo			*vinfo;
	C_Volume			*volume;
	char				string[256];
	Arg				args[1];	

	vinfo = oco_info.volume_info[volume_index];
	volume = world.volume[volume_index];

        sprintf( string, "Modify %s Color -- MODIFIED", volume->volume_name );
        XtSetArg( args[0], XmNdialogTitle, 
                XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
        XtSetValues( vinfo->color.volume_color_displayed, args, 1 );
}
