/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Object Properties 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <X11/StringDefs.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_oco.h"




void oco_s_opacity_input( w, seg_info, event )
Widget		w;
OcoSegInfo	*seg_info;
XEvent		*event;
{
	extern void oco_draw_color_array();

	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	void 		oco_draw_s_opacity();


	static OcoEditType	edit_type = C_NO_EDIT;

	static int		old_x = -1;
	static int		old_y = -1;	
	int			x, y;
	int			loop;

	Arg			args[1];
	char			string[256];
	C_Volume		*volume;
	OcoVolumeInfo		*vinfo;

	
	vinfo = oco_info.volume_info[seg_info->volume_index];

	switch ( event->type )
	{
	    case ButtonPress:
		edit_type = seg_info->s_opacity_edit_type;
                sprintf( string, "Modify %s Segmentation -- MODIFIED",
                        world.volume[seg_info->volume_index]->volume_name );
                XtSetArg( args[0], XmNdialogTitle, 
                        XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
                XtSetValues( vinfo->data.volume_data_displayed, args, 1 );
	
		if ( edit_type == C_RED_COLOR_EDIT ||
		     edit_type == C_GREEN_COLOR_EDIT ||
		     edit_type == C_BLUE_COLOR_EDIT )
		{		
		    if ( vinfo->color.volume_color_displayed )
		    {
                        sprintf( string, "Modify %s Color -- MODIFIED",
                          world.volume[seg_info->volume_index]->volume_name );
                        XtSetArg( args[0], XmNdialogTitle, 
                          XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
                        XtSetValues(vinfo->color.volume_color_displayed,args,1);
		    }
		}

		break;

	    case ButtonRelease:
		edit_type = C_NO_EDIT;
		old_x = -1;
		old_y = -1;
		break;

	    case MotionNotify:

		volume = world.volume[seg_info->volume_index];

		x = event->xbutton.x;
		y = 255 - event->xbutton.y;

		if ( x < 0 ) x = 0;
		if ( x > 255 ) x = 255;
		if ( y < 0 ) y = 0;
		if ( y > 255 ) y = 255;

		if ( edit_type != C_NO_EDIT && old_x == -1 )
		{
		 	old_x = x;
			old_y = y;
		}
		switch ( edit_type )
		{
                    case C_RED_COLOR_EDIT:
 
                        if ( old_x == x )
                        {
                          vinfo->color.color_array_red[x] = y;
                        }
                        else if ( old_x <= x )
                        {
                          for ( loop = old_x; loop <= x; loop++ )
                          {
                                vinfo->color.color_array_red[loop] =
                                        old_y + ( (float)(loop - old_x) /
                                                  (float)(   x - old_x) ) *
                                                ( y - old_y );
                          }
                        }
                        else
                        {
                          for ( loop = old_x; loop >= x; loop-- )
                          {
                                vinfo->color.color_array_red[loop] =
                                        old_y + ( (float)(loop - old_x) /
                                                  (float)(   x - old_x) ) *
                                                ( y - old_y );
                          }
                        }
 
                        oco_draw_color_array(seg_info->volume_index, old_x, x);
			oco_draw_s_opacity( seg_info, old_x, x );

			old_x = x;
			old_y = y;
 
                        break;

                    case C_GREEN_COLOR_EDIT:
 
                        if ( old_x == x )
                        {
                          vinfo->color.color_array_green[x] = y;
                        }
                        else if ( old_x <= x )
                        {
                          for ( loop = old_x; loop <= x; loop++ )
                          {
                                vinfo->color.color_array_green[loop] =
                                        old_y + ( (float)(loop - old_x) /
                                                  (float)(   x - old_x) ) *
                                                ( y - old_y );
                          }
                        }
                        else
                        {
                          for ( loop = old_x; loop >= x; loop-- )
                          {
                                vinfo->color.color_array_green[loop] =
                                        old_y + ( (float)(loop - old_x) /
                                                  (float)(   x - old_x) ) *
                                                ( y - old_y );
                          }
                        }
 
                        oco_draw_color_array(seg_info->volume_index, old_x, x);
			oco_draw_s_opacity( seg_info, old_x, x );

			old_x = x;
			old_y = y;
 
                        break;
 
                    case C_BLUE_COLOR_EDIT:
 
                        if ( old_x == x )
                        {
                          vinfo->color.color_array_blue[x] = y;
                        }
                        else if ( old_x <= x )
                        {
                          for ( loop = old_x; loop <= x; loop++ )
                          {
                                vinfo->color.color_array_blue[loop] =
                                        old_y + ( (float)(loop - old_x) /
                                                  (float)(   x - old_x) ) *
                                                ( y - old_y );
                          }
                        }
                        else
                        {
                          for ( loop = old_x; loop >= x; loop-- )
                          {
                                vinfo->color.color_array_blue[loop] =
                                        old_y + ( (float)(loop - old_x) /
                                                  (float)(   x - old_x) ) *
                                                ( y - old_y );
                          }
                        }
 
                        oco_draw_color_array(seg_info->volume_index, old_x, x);
			oco_draw_s_opacity( seg_info, old_x, x );

			old_x = x;
			old_y = y;
  
                        break;

		    case C_OPACITY_EDIT:

			if ( old_x == x )
			{
			  seg_info->s_opacity[x] = y;
			}
			else if ( old_x <= x )
			{
			  for ( loop = old_x; loop <= x; loop++ )
			  {
				seg_info->s_opacity[loop] = 
					old_y + ( (float)(loop - old_x) / 
						  (float)(   x - old_x) ) * 
						( y - old_y );
			  }
			}
			else
			{
			  for ( loop = old_x; loop >= x; loop-- )
			  {
				seg_info->s_opacity[loop] = 
					old_y + ( (float)(loop - old_x) / 
						  (float)(   x - old_x) ) * 
						( y - old_y );
			  }
			}
			
			oco_draw_s_opacity( seg_info, old_x, x );

			old_x = x;
			old_y = y;
			
			break;
		}

		sprintf(string, "%d", x );
		XtSetArg( args[0], XmNlabelString, 
		  XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		XtSetValues( seg_info->s_opacity_x_label, args, 1 );

		sprintf(string, "%1.4f", 
			((float) seg_info->s_opacity[x] / 255.0) * 
				 seg_info->s_opacity_max );
		XtSetArg( args[0], XmNlabelString, 
		  XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		XtSetValues( seg_info->s_opacity_opacity_label, args, 1 );

		if ( volume->color_type == C_COLOR_ARRAY )
		{

		    sprintf(string, "%1.4f (Opacity)  %1.2f (RGB)", 
			((float) y / 255.0) * seg_info->s_opacity_max,
			((float) y / 255.0) );
		    XtSetArg( args[0], XmNlabelString, 
		      XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		    XtSetValues( seg_info->s_opacity_y_label, args, 1 );

		    sprintf(string, "%1.2f", 
			(float)(vinfo->color.color_array_red[x])/255.0 ); 
		    XtSetArg( args[0], XmNlabelString, 
		      XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		    XtSetValues( seg_info->s_opacity_r_label, args, 1 );

		    sprintf(string, "%1.2f", 
			(float)(vinfo->color.color_array_green[x])/255.0 );
		    XtSetArg( args[0], XmNlabelString, 
		      XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		    XtSetValues( seg_info->s_opacity_g_label, args, 1 );

		    sprintf(string, "%1.2f", 
			(float)(vinfo->color.color_array_blue[x])/255.0 ); 
		    XtSetArg( args[0], XmNlabelString, 
		      XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		    XtSetValues( seg_info->s_opacity_b_label, args, 1 );
		}
		else
		{
		    sprintf(string, "%1.4f (Opacity)", 
			((float) y / 255.0) * seg_info->s_opacity_max );
		    XtSetArg( args[0], XmNlabelString, 
		      XmStringCreate( string, XmSTRING_DEFAULT_CHARSET ) );
		    XtSetValues( seg_info->s_opacity_y_label, args, 1 );
		}

		break;
	}
}

void oco_s_opacity_expose( w, seg_info, call_data )
Widget		w;
OcoSegInfo	*seg_info;
XtPointer	call_data;
{
	extern	C_WindowDefs	window_defs;

	void	oco_draw_s_opacity();

	XColor		color;
	int		pixel;
	XGCValues	gcvalues;

	if ( seg_info->s_opacity_gc == NULL )
	{
		color.red = 0;
		color.green = 0;
		color.blue = 0;
		
		if ( window_defs.depth == 24 )
			pixel = C_Get_Pixel( color );
		else if ( window_defs.depth == 8 )
			pixel = window_defs.first_color_index;

		gcvalues.background = pixel;

		seg_info->s_opacity_gc = XCreateGC( 
			XtDisplay( seg_info->s_opacity_draw_area ),
			XtWindow( seg_info->s_opacity_draw_area ),
		 	GCBackground, &gcvalues );
	}

	oco_draw_s_opacity( seg_info, 0, 255 );
}

void oco_draw_s_opacity( seg_info, min, max )
OcoSegInfo		*seg_info;
int			min;
int			max;
{
	extern C_World			world;
	extern C_WindowDefs		window_defs;
	extern C_ObjectControlInfo	oco_info;

	C_Volume		*volume;
	int			loop;
	int			tmp;
	XColor			color;
	int			pixel;
	XGCValues		gcvalues;
	OcoVolumeInfo		*vinfo;

	if ( !seg_info ) return;
	if ( !seg_info->s_opacity_gc ) return;

	if ( min > max )
	{
		tmp = min;
		min = max;
		max = tmp;
	}
	volume =  world.volume[seg_info->volume_index];
	vinfo = oco_info.volume_info[seg_info->volume_index];

	for ( loop = 0; loop <= max; loop++ )
	{
		color.red   = 
		color.green = 
		color.blue  = seg_info->s_opacity[loop];

		if ( window_defs.depth == 24 )
		{
			color.red   *= 256;
                        color.green *= 256;
                        color.blue  *= 256;
			pixel = C_Get_Pixel( color );
		}
		else if ( window_defs.depth == 8 )
			pixel = window_defs.first_grey_index +
				( seg_info->s_opacity[loop] / 4 ); 

		gcvalues.foreground = pixel;	
		XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc,
			   GCForeground, &gcvalues );

		XDrawLine( XtDisplay( seg_info->s_opacity_draw_area ),
			   XtWindow( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc, loop, 256, loop, 285 );
	}

	if ( volume->color_type == C_COLOR_ARRAY )
	  for ( loop = 0; loop <= max; loop++ )
	  {
		
                color.red   = vinfo->color.color_array_red[loop];
                color.green = vinfo->color.color_array_green[loop];
                color.blue  = vinfo->color.color_array_blue[loop];
                if ( window_defs.depth == 24 )
                {
                        color.red   *= 256;
                        color.green *= 256;
                        color.blue  *= 256;
                        pixel = C_Get_Pixel( color );
                }
                else if ( window_defs.depth == 8 )
                    pixel = window_defs.first_color_index +
                        C_Round(((float)( color.red )/63.75))*25 +
                        C_Round(((float)( color.green )/63.75))*5 +
                        C_Round(((float)( color.blue )/63.75));
 

		gcvalues.foreground = pixel;	
		XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc,
			   GCForeground, &gcvalues );

		XDrawLine( XtDisplay( seg_info->s_opacity_draw_area ),
			   XtWindow( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc, loop, 271, loop, 285 );
	  }

	color.red = color.green = color.blue = 0;

	if ( window_defs.depth == 24 )
		pixel = C_Get_Pixel( color );
	else if ( window_defs.depth == 8 )
		pixel = window_defs.first_grey_index;

	gcvalues.foreground = pixel;
	XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
		   seg_info->s_opacity_gc,
		   GCForeground, &gcvalues );

	XFillRectangle( XtDisplay( seg_info->s_opacity_draw_area ),
		        XtWindow( seg_info->s_opacity_draw_area ),
		        seg_info->s_opacity_gc, 
			min-1, 0, (max - min) + 3, 256 );

	if ( min > 0 ) min--;
	if ( max < 255 ) max++;
	if ( min > 0 ) min--;
	if ( max < 255 ) max++;

	color.red = color.green = color.blue = 255;

	if ( window_defs.depth == 24 )
	{
		color.red   *= 256;
                color.green *= 256;
                color.blue  *= 256;
		pixel = C_Get_Pixel( color );
	}
	else if ( window_defs.depth == 8 )
		pixel = window_defs.first_grey_index + 63;

	gcvalues.foreground = pixel;
	XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
		   seg_info->s_opacity_gc,
		   GCForeground, &gcvalues );

	for ( loop = min; loop < max; loop++ )
	{
		XDrawLine( XtDisplay( seg_info->s_opacity_draw_area ),
			   XtWindow( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc, 
			   loop, 255 - seg_info->s_opacity[loop], 
			   loop+1, 255 - seg_info->s_opacity[loop+1] );
	}

	if ( volume->color_type == C_COLOR_ARRAY )
	{
            color.red = 255;
            color.green = 0;
            color.blue = 0;
 
            if ( window_defs.depth == 24 )
            {
                color.red   *= 256;
                color.green *= 256;
                color.blue  *= 256;
                pixel = C_Get_Pixel( color );
            }
            else if ( window_defs.depth == 8 )
                pixel = window_defs.first_color_index +
                    C_Round(((float)( color.red )/63.75))*25 +
                    C_Round(((float)( color.green )/63.75))*5 +
                    C_Round(((float)( color.blue )/63.75));
 
            gcvalues.foreground = pixel;
	    XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
		   seg_info->s_opacity_gc,
		   GCForeground, &gcvalues );
 
            for ( loop = min; loop < max; loop++ )
            {
		XDrawLine( XtDisplay( seg_info->s_opacity_draw_area ),
			   XtWindow( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc, 
                           loop, 255 - vinfo->color.color_array_red[loop],
                           loop+1, 255 - vinfo->color.color_array_red[loop+1] );
            }
 
            color.red = 0;
            color.green = 255;
            color.blue = 0;
 
            if ( window_defs.depth == 24 )
            {
                color.red   *= 256;
                color.green *= 256;
                color.blue  *= 256;
                pixel = C_Get_Pixel( color );
            }
            else if ( window_defs.depth == 8 )
                pixel = window_defs.first_color_index +
                    C_Round(((float)( color.red )/63.75))*25 +
                    C_Round(((float)( color.green )/63.75))*5 +
                    C_Round(((float)( color.blue )/63.75));
 
            gcvalues.foreground = pixel;
	    XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
		   seg_info->s_opacity_gc,
		   GCForeground, &gcvalues );
 
            for ( loop = min; loop < max; loop++ )
            {
		XDrawLine( XtDisplay( seg_info->s_opacity_draw_area ),
			   XtWindow( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc, 
                           loop, 255 - vinfo->color.color_array_green[loop],
                           loop+1, 255-vinfo->color.color_array_green[loop+1] );
            }
 
            color.red = 0;
            color.green = 0;
            color.blue = 255;
 
            if ( window_defs.depth == 24 )
            {
                color.red   *= 256;
                color.green *= 256;
                color.blue  *= 256;
                pixel = C_Get_Pixel( color );
            }
            else if ( window_defs.depth == 8 )
                pixel = window_defs.first_color_index +
                    C_Round(((float)( color.red )/63.75))*25 +
                    C_Round(((float)( color.green )/63.75))*5 +
                    C_Round(((float)( color.blue )/63.75));
 
            gcvalues.foreground = pixel;
	    XChangeGC( XtDisplay( seg_info->s_opacity_draw_area ),
		   seg_info->s_opacity_gc,
		   GCForeground, &gcvalues );
 
            for ( loop = min; loop < max; loop++ )
            {
		XDrawLine( XtDisplay( seg_info->s_opacity_draw_area ),
			   XtWindow( seg_info->s_opacity_draw_area ),
			   seg_info->s_opacity_gc, 
                           loop, 255 - vinfo->color.color_array_blue[loop],
                           loop+1, 255-vinfo->color.color_array_blue[loop+1] );
            }

	}
}
