/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: GL_ivi_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: GL and Motif 
 *			      Windowing Routines Of The Image Viewer 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"

void ivi_setup_drawing_area( drawing_area, parent, width, height, image_num )
Widget		*drawing_area;
Widget		parent;
int		width;
int		height;
int		image_num;
{
	extern C_ImageTable	image_table;

	Arg		args[20];	/* Argument List */
	int		n;		/* Argument Count */


	/********************************************************/		
	/*	Create a Drawing Area for Active Image		*/
	/********************************************************/		
        n=0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        XtSetArg( args[n], XmNwidth, width ); n++;
        XtSetArg( args[n], XmNheight, height ); n++;

        *drawing_area = XmCreateDrawingArea( parent,
                       "drawing_area", args, n );

	XtManageChild( *drawing_area );

	image_table.image_entry[image_num]->graph_win = 
		XCreateGC( XtDisplay( *drawing_area ), 
			   XtWindow( *drawing_area ), NULL, 0 );
}

void ivi_display_image( image_num )
int		image_num;
{
	extern C_Byte		*C_dither_image_8bit();

	extern C_WindowDefs	window_defs;
	extern C_ImageTable	image_table;

	C_Image			*image;
	XImage			*ximage;
	C_Byte			*rptr, *gptr, *bptr;
	C_Byte			*image_data, *iptr;
	Widget			ui_win;
	int			byte_mult;
	int			loop;

	if ( image_num < 0  || image_num > image_table.num_images) return;

	image = image_table.image_entry[image_num]->image;
	ui_win = image_table.image_entry[image_num]->ui_win;

	if ( window_defs.depth == 8 )
	{
		image_data = C_dither_image_8bit( image );
		byte_mult = 1;
	}
	else if ( window_defs.depth == 24 )
	{
		image_data = (C_Byte *) malloc( image->width * image->height 
						* sizeof( int ) );
		iptr = image_data;
		rptr = image->red;
		gptr = image->green;
		bptr = image->blue;

		for (loop = 0; loop < image->width * image->height; loop++)
		{
		  *(iptr++) = 0;
		  *(iptr++) = *(bptr++);
		  *(iptr++) = *(gptr++);
		  *(iptr++) = *(rptr++);
		}
		byte_mult = 4;
	}

	ximage = XCreateImage( XtDisplay( ui_win ),
                               window_defs.visual,  window_defs.depth,
                               ZPixmap, 0, image_data, image->width, 
			       image->height, 8, image->width*byte_mult );
 

        XPutImage( XtDisplay( ui_win ), XtWindow( ui_win ), 
		   image_table.image_entry[image_num]->graph_win,
                   ximage, 0, 0, 0, 0, image->width, image->height );
 
        free( image_data );
 
        XDestroyImage( ximage );

}
