/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: MOTIF_ide_simulation.c
 *                    Author: He, Taosong
 *                      Date: 7/20/1993
 *               Description: Mouse Control Panel Interface
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *       
 */

/******************************************************************/
/*                The standard C include files                    */
/******************************************************************/
# include <stdio.h>


/******************************************************************/
/*               The MOTIF include files                          */
/******************************************************************/
# include <X11/Intrinsic.h>
# include <X11/Shell.h>
# include <X11/Xlib.h>
# include <X11/Xutil.h>
# include <Xm/Xm.h>
# include <Xm/RowColumn.h>
# include <Xm/Frame.h>
# include <Xm/Form.h>
# include <Xm/ToggleBG.h>
# include <Xm/ToggleB.h>
# include <Xm/Text.h>
# include <Xm/PushB.h>
# include <Xm/PushBG.h>
# include <Xm/LabelG.h>
# include <Xm/CascadeB.h>
# include <Xm/BulletinB.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/DialogS.h>
# include <Xm/MessageB.h>

/******************************************************************/
/*                  VolVis include files                          */
/******************************************************************/
#include "MOTIF_windefs.h"
#include "C_ide.h"
#include "C_volvis.h"


static  Widget mouse_simulation_panel_manual;
static  Widget mouse_simulation_panel_method;

C_IDE_mouse_method C_ide_mouse_method;

void C_create_mouse_simulation_panel(w, client_data, call_data)
Widget w;
Widget client_data;
caddr_t call_data;
{
   extern C_IDE_simulation_method C_ide_simulation_method;

   void   create_simulation_manual();
   void   create_simulation_method();



   if (C_ide_simulation_method.mouse.choice == 1)
     create_simulation_manual(client_data);
   else 
     create_simulation_method(client_data);
}

void create_simulation_manual(parent)
Widget parent;
{
        extern C_WindowDefs     window_defs;
 

        Widget flabel[2], frame, frame1, bb, bb1;
        Widget tran_label[3], tran_text[3];
        Widget rota_label[3], rota_text[3];
   
        Arg args[20];
        XmString string;
        int n;

        if (mouse_simulation_panel_method)
         {
            XtDestroyWidget(mouse_simulation_panel_method);
         }

        if (mouse_simulation_panel_manual)
         {
            XtManageChild(mouse_simulation_panel_manual);
            return;
         }

        n = 0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        string = XmStringCreate("Mouse Simulation Panel", 
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, string ); n++;
        mouse_simulation_panel_manual = XmCreateBulletinBoardDialog(
                                   parent, "", args, n);
        
 
        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 10 ); n++;
        flabel[0] = XmCreateLabelGadget(mouse_simulation_panel_manual, 
                                        "Transformation amount:", args, n);
        XtManageChild(flabel[0]);

        n = 0;
        XtSetArg (args[n], XmNshadowType, XmSHADOW_ETCHED_IN);  n++;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 35);  n++;
        XtSetArg( args[n], XmNheight, 135 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame (mouse_simulation_panel_manual, "frame", args, n);
        XtManageChild (frame);

        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bb = XmCreateBulletinBoard (frame, "bb", args, n);
        XtManageChild (bb);

        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        string = XmStringCreate("X unit",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        tran_label[0] = XmCreateLabel(bb,
                                "X Unit", args, n);
        XmStringFree (string);

        n  = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        tran_text[0] = XmCreateText (bb, "x", args, n);

        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 50);  n++;
        string = XmStringCreate("Y unit",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        tran_label[1] = XmCreateLabel(bb,
                                "Y Unit", args, n);
        XmStringFree (string);

        n = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 50);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        tran_text[1] = XmCreateText (bb, "y", args, n);

        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 90);  n++;
        string = XmStringCreate("Z unit",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        tran_label[2] = XmCreateLabel(bb,
                                "Y Unit", args, n);
        XmStringFree (string);

        n = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 90);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        tran_text[2] = XmCreateText (bb, "z", args, n);

        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 200 ); n++;
        flabel[1] = XmCreateLabelGadget(mouse_simulation_panel_manual,
                                        "Rotation amount:", args, n);
        XtManageChild(flabel[1]);

        n = 0;
        XtSetArg (args[n], XmNshadowType, XmSHADOW_ETCHED_IN);  n++;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 225);  n++;
        XtSetArg( args[n], XmNheight, 135 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame1= XmCreateFrame (mouse_simulation_panel_manual, "frame", args, n);
        XtManageChild (frame1);

        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bb1 = XmCreateBulletinBoard (frame1, "bb1", args, n);
        XtManageChild (bb1);

        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        string = XmStringCreate("X angle",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        rota_label[0] = XmCreateLabel(bb1,
                                "X Unit", args, n);
        XmStringFree (string);

        n  = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 5);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        rota_text[0] = XmCreateText (bb1, "x", args, n);

        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 50);  n++;
        string = XmStringCreate("Y angle",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        rota_label[1] = XmCreateLabel(bb1,
                                "Y Unit", args, n);
        XmStringFree (string);

        n = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 50);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        rota_text[1] = XmCreateText (bb1, "y", args, n);

        
        n = 0;
        XtSetArg (args[n], XmNx, 10);  n++;
        XtSetArg (args[n], XmNy, 90);  n++;
        string = XmStringCreate("Z angle",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        rota_label[2] = XmCreateLabel(bb1,
                                "Y Unit", args, n);
        XmStringFree (string);

        n = 0;
        XtSetArg (args[n], XmNx, 100);  n++;
        XtSetArg (args[n], XmNy, 90);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        XtSetArg( args[n], XmNvalue, "0.0" ); n++;
        C_Set_Color_Text( args, n, window_defs );
        rota_text[2] = XmCreateText (bb1, "z", args, n);


        XtManageChildren(tran_label,3);
        XtManageChildren(tran_text,3);
        XtManageChildren(rota_label,3);
        XtManageChildren(rota_text,3);
        
        XtManageChild(mouse_simulation_panel_manual);
}


void create_simulation_method(parent)
Widget parent;
{
        extern C_IDE_simulation_method C_ide_simulation_method;
        extern C_WindowDefs     window_defs;

        void create_triad_mouse();

        Arg args[20];
        XmString string;
        int n;

        n = 0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        string = XmStringCreate("Mouse Simulation Panel",
                                XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, string ); n++;
        mouse_simulation_panel_method = XmCreateBulletinBoardDialog(
                                   parent, "", args, n);

        if (C_ide_simulation_method.mouse.trans_simu == C_Triad_Mouse)
          create_triad_mouse(mouse_simulation_panel_method);

        XtManageChild(mouse_simulation_panel_method);

}
 

void set_triad_mode(w, client_data, call_data)
Widget w;
int client_data;
XmToggleButtonCallbackStruct *call_data;
{
        C_ide_mouse_method.triad.mode = client_data;
}

void create_triad_mouse(parent)
Widget parent;
{
        extern C_WindowDefs     window_defs;

        Arg args[20];
        XmString string;
        int n;

        Widget flabel, frame, radiobox;
        Widget toggle[2];

        if (mouse_simulation_panel_manual)
         {
           XtUnmanageChild(mouse_simulation_panel_manual);
         }

        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 10 ); n++;
        string = XmStringCreate ("Triad Mouse Mode:", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        flabel = XmCreateLabelGadget(parent, "Triad Mouse Mode:", args, n);
        XtManageChild(flabel);
        XmStringFree (string);

        n = 0;
        XtSetArg (args[n], XmNx, 160);  n++;
        XtSetArg (args[n], XmNy, 10);  n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame (parent, "frame", args, n);
        XtManageChild (frame);

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RadioBox( args, n, window_defs );
        radiobox = XmCreateRadioBox (frame, "radiobox", args, n);
        XtManageChild (radiobox);

        n = 0;
        string = XmStringCreate ("Normal", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle[0] = XtCreateWidget ("Normal", xmToggleButtonWidgetClass,
                                     radiobox, args, n);
        XtAddCallback(toggle[0], XmNvalueChangedCallback,
                                    set_triad_mode, C_MOUSE_NORMAL);
        XmStringFree (string);

        n = 0;
        string = XmStringCreate ("Dominate ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        toggle[1] = XtCreateWidget ("Dominate ",xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XtAddCallback(toggle[1], XmNvalueChangedCallback,
                                    set_triad_mode, C_MOUSE_DOMINATE);
        XmStringFree (string);


        n = 0;
        XtSetArg( args[n], XmNset, TRUE ); n++;
        XtSetValues (toggle[C_ide_mouse_method.triad.mode], args, n); 
        XtManageChildren (toggle, 2);
}
 


         


        

 

   
   
