/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: MOTIF_mouse.c 
 *                  Author: He, Taosong
 *                  Date:   1/18/93 
 *           Description: MOTIF routines for driving input device mouse 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/******************************************************************/
/*               The MOTIF include file                           */
/******************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/Label.h>
#include <X11/Xutil.h>
#include <varargs.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>

/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/


#include <stdio.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_volvis.h"
#include "C_ide.h"
#include "MOTIF_windefs.h"

/******************************************************************/
/******************************************************************/                    

Widget mouse_token_bulletin; /* Global Widget in mouse panel on which
                                    the token information displayed */ 

/*
 *        Procedure Name: report_token
 *          Return Value: void 
 *       Input Variables: a string to be displayed 
 *      Output Variables:
 *      Update Variables:
 *      Global Variables: mouse_token_bulletin
 *           Description: Display the input string on mouse_token_bulletin
 */

void mouse_report_token(str)
char *str;
{
  extern void C_ide_report_token();

   C_ide_report_token(str, mouse_token_bulletin);
}

void C_ide_fill_in_mouse_token(w)
Widget w;
{

   extern void monitor_mouse_motion();
 
  static  Display *display;
  static  Window  window;

  Window          root_win;
  Window          child_win;
  int             rx, ry;         /* Root Cursor Position */
  int             cx, cy;         /* Child Cursor Position */
  int             mask;

  display = XtDisplay(w);
  window = XtWindow(w);

  XQueryPointer(display, window, &root_win, &child_win,
                &rx, &ry, &cx, &cy, &mask );

  monitor_mouse_motion(cx, cy);

}


/*
 *        Procedure Name: m_set_1_axis
 *          Return Value: void
 *       Input Variables: drawingarea
 *                        XmAnyCallbackStruct *call_data; 
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: A call_back function. Set the drawingarea's triad
 *                        mouse mode to be 1 axis. That is, only the movement
 *                        along the axis which has the biggese projection 
 *                        is caculated. 
 */

void m_set_1_axis(drawingarea,call_data)
  Widget drawingarea;
  XmAnyCallbackStruct *call_data;
{
  extern void mouse_set_mode();

  mouse_set_mode(MOUSE_ONE_AXIS_MODE);
}

/*
 *        Procedure Name: m_set_3_axes
 *          Return Value: void
 *       Input Variables: drawingarea
 *                        XmAnyCallbackStruct *call_data;
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: A call_back function. Set the drawingarea's triad
 *                        mouse mode to be 3 axis. That is, all the movements
 *                        along the three axes which has the biggese i
 *                        projection are caculated.
 */

void m_set_3_axes(drawingarea,call_data)
  Widget drawingarea; 
  XmAnyCallbackStruct *call_data;
{ 
  extern void mouse_set_mode();

  mouse_set_mode(MOUSE_THREE_AXES_MODE);
}

/*
 *        Procedure Name: m_set_arcball
 *          Return Value: void
 *       Input Variables: drawingarea;
 *                        XmAnyCallbackStruct *call_data;
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: A call_back function. Set the drawingarea's 
 *                        mouse mode to be arcball. That is, use arcball
 *                        to report the quaternion representation of the 
 *                        orientation .
 */

void m_set_arcball(drawingarea,call_data) 
  Widget drawingarea;  
  XmAnyCallbackStruct *call_data; 
{  
  extern void mouse_set_mode();

  mouse_set_mode(MOUSE_ARCBALL_MODE);
}


/*
 *        Procedure Name: m_get_token 
 *          Return Value: void
 *       Input Variables: drawingarea;
 *                        XmAnyCallbackStruct *call_data;
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: A call_back function. Display the token information 
 *                        in the information panel. 
 */

void m_get_token(drawingarea,call_data)
  Widget drawingarea;
  XmAnyCallbackStruct *call_data;
{ 
      
   extern void  C_report_mouse_token();
      
   C_report_mouse_token();
}  

