/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *			File: C_motif_win.c
 *		      Author: Rick Avila & Morita
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_fio.h"
#include "C_help.h"

/* Global Variables For Motif Windowing */
extern Widget		vv_toplevel;	/* VolVis toplevel Shell Widget */
extern Widget		fio_bbdialog;	/* File I/O Bulletin Board Dialog */
extern C_WindowDefs	window_defs;

Widget	fio_load_bbdialog = NULL;
Widget	fio_save_bbdialog = NULL;

void create_fio_window()
{
	extern	void close_callback();
	void	fio_load_callback();
	void	fio_save_callback();
	void	help_callback();

	Arg		args[15];	/* Argument List */
	int		n;		/* Argument Count */
	Widget		fio_load_button;
	Widget		fio_save_button;
	Widget		fio_close_button;
	Widget		fio_help_button;
	Widget		frame1, frame2;
	Widget		rowcolumn1, rowcolumn2;
	XmString	label_string;

	/************************************************/
	/*     Create The File Input Output Window	*/
	/************************************************/

	n=0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	label_string = XmStringCreate( "File I/O", XmSTRING_DEFAULT_CHARSET);
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	fio_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
		       "File I/O", args, n );
	XmStringFree(label_string);

        /************************************************/
        /*     Create A Frame To Hold The Buttons       */
        /************************************************/

        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 15); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame1 = XmCreateFrame( fio_bbdialog, "frame_1", args, n );
        XtManageChild( frame1 );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNspacing, 20); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn1 = XmCreateRowColumn(frame1, "rowcolumn_1", args, n);
        XtManageChild (rowcolumn1);

	/************************************************/
	/*     Create The File Load Button		*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	fio_load_button = XtCreateManagedWidget( "  Load  ", 
		xmPushButtonWidgetClass, rowcolumn1, args, n );
	XtAddCallback( fio_load_button, XmNactivateCallback, 
		       fio_load_callback, fio_bbdialog );
	XtManageChild( fio_load_button );


	/************************************************/
	/*     Create The File Save Button		*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	fio_save_button = XtCreateManagedWidget( "  Save  ", 
		xmPushButtonWidgetClass, rowcolumn1, args, n );
	XtAddCallback( fio_save_button, XmNactivateCallback,
		       fio_save_callback, fio_bbdialog );
	XtManageChild( fio_save_button );

        /************************************************/
        /*     Create A Frame To Hold The Buttons       */
        /************************************************/

        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 70); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame2 = XmCreateFrame( fio_bbdialog, "frame_2", args, n );
        XtManageChild( frame2 );

        n = 0;
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        XtSetArg( args[n], XmNspacing, 20); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn2 = XmCreateRowColumn(frame2, "rowcolumn_2", args, n);
        XtManageChild (rowcolumn2);


	/************************************************/
	/*     Create The File Close Button		*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	fio_close_button = XtCreateManagedWidget( " Close ", 
		xmPushButtonWidgetClass, rowcolumn2, args, n );
	XtAddCallback( fio_close_button, XmNactivateCallback,
		       close_callback, fio_bbdialog );
	XtManageChild( fio_close_button );

	/************************************************/
	/*     Create The File Help Button		*/
	/************************************************/
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	fio_help_button = XtCreateManagedWidget( "  Help  ", 
		xmPushButtonWidgetClass, rowcolumn2, args, n );
	XtManageChild( fio_help_button );

        XtAddCallback( fio_help_button , XmNactivateCallback,
                                help_callback , C_FIO_HELP );
 
}

void fio_load_callback(w, client_data, call_data)
Widget w;
Widget client_data;
caddr_t call_data;
{
  extern void	create_fio_load_window();
  extern int C_load_file();


  if( fio_load_bbdialog )
  {
	  if( XtIsManaged(fio_load_bbdialog) )
	  {
		  XtUnmanageChild( fio_load_bbdialog );
	  }
	  XtManageChild( fio_load_bbdialog );
  }
  else
  {
	  create_fio_load_window();
  }
}

void fio_save_callback(w, client_data, call_data)
Widget w;
Widget client_data;
caddr_t call_data;
{
  extern  void	create_fio_save_window();

  if( fio_save_bbdialog )
  /*  if fio_save_bbdialog already exist, unmanage it and create a new one */
  {
	  if( XtIsManaged(fio_save_bbdialog) )
	  /* If fio_save_bbdialog is managed */
	  {
		  XtUnmanageChild( fio_save_bbdialog );
	  }
	  XtManageChild( fio_save_bbdialog );
  }
  else
  /* if there is no fio_save_bbdialog, just create it */
  {
	  create_fio_save_window();
  }
}


