/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/





/*
 *			File: C_vector.c
 *		      Author: Lisa Sobierajski
 *			Date: 12/14/92
 *		 Description: Vector Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

# include <stdio.h>
# include <math.h>

# include "C_volvis.h"


void C_define_c_sys_from_vector( in_vector, out_vector1, out_vector2 )
C_FVector	*in_vector;
C_FVector	*out_vector1;
C_FVector	*out_vector2;
{

	float		t;

    	if ( in_vector->z )
    	{
	    out_vector1->x = 1.0;
	    out_vector1->y = 1.0;
	    out_vector1->z = ( in_vector->x + in_vector->y ) / -in_vector->z;

    	    C_Normalize( out_vector1->x, out_vector1->y, out_vector1->z, t );
    	}
    	else if ( in_vector->y )
    	{
	    out_vector1->x = 1.0;
	    out_vector1->y = in_vector->x / -in_vector->y;
	    out_vector1->z = 0.0;

    	    C_Normalize( out_vector1->x, out_vector1->y, out_vector1->z, t );
    	}
    	else
    	{
	    out_vector1->x = 0.0;
	    out_vector1->y = 1.0;
	    out_vector1->z = 0.0;
    	}

    	out_vector2->x = 
		(in_vector->y * out_vector1->z) - 
		(in_vector->z * out_vector1->y); 

    	out_vector2->y = 
		(in_vector->z * out_vector1->x) - 
		(in_vector->x * out_vector1->z); 

    	out_vector2->z = 
		(in_vector->x * out_vector1->y) - 
		(in_vector->y * out_vector1->x); 

   	C_Normalize( out_vector2->x, out_vector2->y, out_vector2->z, t );
}
