/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



# include <stdio.h>
# include <math.h>

# include "C_volvis.h"

C_create_plane_equations( volume )
C_Volume		*volume;

{

	/****    Find the plane equation for the   ****/
	/****    C_MINUS_X_FACE of the volume      ****/
	
	volume->plane_equation[C_MINUS_X_FACE].a = 
		-1.0*volume->c_sys.x_axis.x;

	volume->plane_equation[C_MINUS_X_FACE].b = 
		-1.0*volume->c_sys.x_axis.y;

	volume->plane_equation[C_MINUS_X_FACE].c = 
		-1.0*volume->c_sys.x_axis.z;

	volume->plane_equation[C_MINUS_X_FACE].d = 
		-1.0 *
		( volume->plane_equation[C_MINUS_X_FACE].a * 
		  volume->c_sys.origin.x +
		  volume->plane_equation[C_MINUS_X_FACE].b *
		  volume->c_sys.origin.y +
		  volume->plane_equation[C_MINUS_X_FACE].c *
		  volume->c_sys.origin.z );


	/****    Find the plane equation for the   ****/
	/****    C_MINUS_Y_FACE of the volume      ****/

	volume->plane_equation[C_MINUS_Y_FACE].a = 
		-1.0*volume->c_sys.y_axis.x;

	volume->plane_equation[C_MINUS_Y_FACE].b = 
		-1.0*volume->c_sys.y_axis.y;

	volume->plane_equation[C_MINUS_Y_FACE].c = 
		-1.0*volume->c_sys.y_axis.z;


	volume->plane_equation[C_MINUS_Y_FACE].d = 
		-1.0 *
		( volume->plane_equation[C_MINUS_Y_FACE].a * 
		  volume->c_sys.origin.x +
		  volume->plane_equation[C_MINUS_Y_FACE].b *
		  volume->c_sys.origin.y +
		  volume->plane_equation[C_MINUS_Y_FACE].c *
		  volume->c_sys.origin.z );


	/****    Find the plane equation for the   ****/
	/****    C_MINUS_Z_FACE of the volume      ****/

	volume->plane_equation[C_MINUS_Z_FACE].a = 
		-1.0*volume->c_sys.z_axis.x;

	volume->plane_equation[C_MINUS_Z_FACE].b = 
		-1.0*volume->c_sys.z_axis.y;

	volume->plane_equation[C_MINUS_Z_FACE].c = 
		-1.0*volume->c_sys.z_axis.z;


	volume->plane_equation[C_MINUS_Z_FACE].d = 
		-1.0 *
		( volume->plane_equation[C_MINUS_Z_FACE].a * 
		  volume->c_sys.origin.x +
		  volume->plane_equation[C_MINUS_Z_FACE].b *
		  volume->c_sys.origin.y +
		  volume->plane_equation[C_MINUS_Z_FACE].c *
		  volume->c_sys.origin.z );


	/****    Find the plane equation for the   ****/
	/****    C_PLUS_X_FACE of the volume       ****/
	
	volume->plane_equation[C_PLUS_X_FACE].a = 
		volume->c_sys.x_axis.x;

	volume->plane_equation[C_PLUS_X_FACE].b = 
		volume->c_sys.x_axis.y;

	volume->plane_equation[C_PLUS_X_FACE].c = 
		volume->c_sys.x_axis.z;

	volume->plane_equation[C_PLUS_X_FACE].d = 
		-1.0*(volume->plane_equation[C_MINUS_X_FACE].d) -
		volume->x_size_units; 


	/****    Find the plane equation for the   ****/
	/****    C_PLUS_Y_FACE of the volume       ****/

	volume->plane_equation[C_PLUS_Y_FACE].a = 
		volume->c_sys.y_axis.x;

	volume->plane_equation[C_PLUS_Y_FACE].b = 
		volume->c_sys.y_axis.y;

	volume->plane_equation[C_PLUS_Y_FACE].c = 
		volume->c_sys.y_axis.z;

	volume->plane_equation[C_PLUS_Y_FACE].d = 
		-1.0*(volume->plane_equation[C_MINUS_Y_FACE].d) -
		volume->y_size_units; 


	/****    Find the plane equation for the   ****/
	/****    C_PLUS_Z_FACE of the volume       ****/

	volume->plane_equation[C_PLUS_Z_FACE].a = 
		volume->c_sys.z_axis.x;

	volume->plane_equation[C_PLUS_Z_FACE].b = 
		volume->c_sys.z_axis.y;

	volume->plane_equation[C_PLUS_Z_FACE].c = 
		volume->c_sys.z_axis.z;

	volume->plane_equation[C_PLUS_Z_FACE].d = 
		-1.0*(volume->plane_equation[C_MINUS_Z_FACE].d) -
		volume->z_size_units; 

}

void C_copy_plane( plane1, plane2 )
C_Plane			*plane1, *plane2;
{
	plane2->a = plane1->a;
	plane2->b = plane1->b;
	plane2->c = plane1->c;
	plane2->d = plane1->d;
}

