/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: C_image_control.c
 *		      Author: Lisa Sobierajski 
 *			Date: 
 *		 Description: Volume Control Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */


# include <stdio.h>
# include <string.h>
# include "C_volvis.h"


int C_enter_light( world, light, light_name, file_name )
C_World			*world;
C_Light			*light;
char			*light_name;
char			*file_name;
{
	int		loop;
	char		tmp_name[30];

	/****	Check if there are any available entries	****/

	if ( world->num_lights == C_MAX_LIGHTS )
	{
		C_error_message("Too many lights!!!\n");
		return C_ERROR;
	}

	world->light[world->num_lights] = light;

	/****   Check if this name exists already - if it    ****/
	/****   does, find the first number we can append to ****/
	/****   it to make it unique			     ****/
	
	loop = 1;

	sprintf( tmp_name, "%s", light_name );

	while ( C_get_light_index(world, tmp_name ) != C_NO_MATCH )
	{
		loop++;
		sprintf(tmp_name, "%s_%d", light_name, loop );
	}

	/****	Now make a copy of the volume_name    ****/
	light->light_name = 
		(char *) malloc( sizeof(char)*(strlen(tmp_name) + 1) );
	strcpy(light->light_name, tmp_name);

	/****	Now make a copy of the file_name    ****/
	if ( file_name )
	{
	  light->file_name = 
		(char *) malloc( sizeof(char)*(strlen(file_name) + 1) );
	  strcpy(light->file_name, file_name);
	}
	else
	{
	  light->file_name = NULL;
	}

	(world->num_lights)++;

	C_update_system( C_LIGHT_CREATED );

	return C_OK;

}

int C_delete_light( world, light_name )
C_World			*world;
char			*light_name;
{
	void		C_free_light();

	int		index;
	C_Light		*light;
	int		loop;

	index = C_get_light_index( world, light_name );
	
	if ( index == C_NO_MATCH ) return C_ERROR;

	light = world->light[index];

	C_free_light( light );

	for ( loop = index; loop < world->num_lights - 1; loop++ )
		world->light[loop] = world->light[loop+1];

	world->light[world->num_lights] = NULL;

	world->num_lights--;

	C_update_system( C_LIGHT_DELETED );
}

void C_free_light( light )
C_Light	*light;
{

	switch ( light->light_type )
	{
	  case C_POINT_LIGHT:

		if ( light->light.light_point )
			free( light->light.light_point );	
		break;
		
	  default:

		C_error_message("fix this\n");
		break;
	}

	if ( light->light_name )
		free( light->light_name );

	if ( light->file_name )
		free( light->file_name );

}


int C_get_light_index( world, light_name )
C_World			*world;
char			*light_name;
{
	int	loop;

	for (loop = 0; loop < world->num_lights; loop++)
	{
		if (strcmp( light_name, world->light[loop]->light_name )
			== 0 ) 
		{
			return loop;
		}
	}
		
	return C_NO_MATCH;
}

int C_clone_light( orig_light )
C_Light		*orig_light;
{
	extern C_World	world;

	C_Light		*clone_light;

	clone_light = C_New( C_Light );

	if ( !clone_light )
	{
		C_error_message("Not enough memory to clone\n");
		return C_ERROR;
	}

	clone_light->visible = orig_light->visible;
	clone_light->modifiable = orig_light->modifiable;
	clone_light->light_type = orig_light->light_type;

	switch ( clone_light->light_type )
	{
	    case C_POINT_LIGHT:

		clone_light->light.light_point = C_New( C_PointLight );

		if ( !clone_light->light.light_point )
		{
			C_error_message("Not enough memory to clone\n");
			free ( clone_light );
			return C_ERROR;
		}
		
		
		clone_light->light.light_point->orig_light_pos.x = 
			orig_light->light.light_point->orig_light_pos.x;
		clone_light->light.light_point->orig_light_pos.y = 
			orig_light->light.light_point->orig_light_pos.y;
		clone_light->light.light_point->orig_light_pos.z = 
			orig_light->light.light_point->orig_light_pos.z;

		clone_light->light.light_point->light_pos.x = 
			orig_light->light.light_point->light_pos.x;
		clone_light->light.light_point->light_pos.y = 
			orig_light->light.light_point->light_pos.y;
		clone_light->light.light_point->light_pos.z = 
			orig_light->light.light_point->light_pos.z;

		C_copy_matrix( &(orig_light->light.light_point->transform),
			       &(clone_light->light.light_point->transform) );	

		clone_light->light.light_point->light_color.red = 
			orig_light->light.light_point->light_color.red;
		clone_light->light.light_point->light_color.green = 
			orig_light->light.light_point->light_color.green;
		clone_light->light.light_point->light_color.blue = 
			orig_light->light.light_point->light_color.blue;

		clone_light->light.light_point->light_intensity = 
			orig_light->light.light_point->light_intensity;


		break;
	}

	if ( ( C_enter_light( &world, clone_light, orig_light->light_name,
			      orig_light->file_name ) ) == C_ERROR )
		return C_ERROR;

	return C_OK;
}
