/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*                  File: C_ide_token.c
 *                Author: He, Taosong 
 *                  Date: 
 *           Description: C routines for tokenizer
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *            
 */



/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/

#include <stdio.h>
#include <varargs.h>	/*** ??? ***/
#include <time.h>
#include <math.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_volvis.h"
#include "C_ide.h"

/*     Global variable: IDE_VD_configuration:
 *                                         The configurations of all
 *                                         virtual devices;
 *                      IDE_active_config: a variable which keeps the
 *                                         virtual device configuration
 *                                         for active drawingarea;
 */

C_IDE_VD_configuration       IDE_VD_configuration [C_MAX_VD_NUMBER];

C_IDE_VD_configuration       IDE_active_config;

/*
 *        Procedure Name: convert_quaternion_matrix
 *          Return Value: void
 *       Input Variables: quaternion
 *      Output Variables: token
 *      Update Variables:
 *      Global Variables:
 *           Description: This functions convert an unit quaternion 
 *                        to a 4x4 rotation matrix.
 */

void convert_quaternion_matrix(token, quaternion)
C_IDE_token *token;
C_FQuaternion quaternion;
{
  float x2, y2, z2, wx2, wy2, wz2, xx2, xy2, xz2,
      yy2, yz2, zz2;

  x2= quaternion.x*2;
  y2= quaternion.y*2;
  z2= quaternion.z*2;
  wx2 = x2 * quaternion.w;
  wy2 = y2 * quaternion.w;
  wz2 = z2 * quaternion.w;
  xx2 = x2 * quaternion.x;
  xy2 = x2 * quaternion.y;
  xz2 = x2 * quaternion.z;
  yy2 = y2 * quaternion.y;
  yz2 = z2 * quaternion.z;
  zz2 = z2 * quaternion.z;

  token->rotation.matrix[0][0] = 1 - yy2 -zz2;
  token->rotation.matrix[0][1] = xy2 + wz2;
  token->rotation.matrix[0][2] = xz2 - wy2;
  token->rotation.matrix[0][3] = 0;
  token->rotation.matrix[1][0] = xy2 - wz2;
  token->rotation.matrix[1][1] = 1- xx2- zz2;
  token->rotation.matrix[1][2] = yz2 + wx2;
  token->rotation.matrix[1][3] = 0;
  token->rotation.matrix[2][0] = xz2 + wy2;
  token->rotation.matrix[2][1] = yz2 - wz2;
  token->rotation.matrix[2][2] = 1 - xx2- yy2;
  token->rotation.matrix[2][3] = 0;
  token->rotation.matrix[3][0] = 0;
  token->rotation.matrix[3][1] = 0;
  token->rotation.matrix[3][2] = 0;
  token->rotation.matrix[3][3] = 1;
}

/*
 *        Procedure Name: convert_euler_matrix
 *          Return Value: void
 *       Input Variables: orientation
 *      Output Variables: token
 *      Update Variables:
 *      Global Variables:
 *           Description: This functions convert an Euler Angles 
 *                        representation to a 4x4 rotation rotation.
 */

void convert_euler_matrix(token, orientation)
C_IDE_token *token;
C_FOrientation orientation;
{

  float sinroll, cosroll, sinpitch, cospitch, sinyaw, cosyaw;

  float sinrollsinpitch, cosrollsinpitch, cosrollsinyaw, cosrollcosyaw;

  float degto= 3.1415926/360;

  sinroll = sin((double)(degto*orientation.a));
  cosroll = cos((double)(degto*orientation.a));
  sinpitch = sin((double)(degto*orientation.b));
  cospitch = cos((double)(degto*orientation.b));
  sinyaw = sin((double)(degto*orientation.r));
  cosyaw = cos((double)(degto*orientation.r));

  sinrollsinpitch = sinroll * sinpitch;
  cosrollsinpitch = cosroll * sinpitch;
  cosrollsinyaw = cosroll * sinyaw;
  cosrollcosyaw = cosroll * cosyaw;

  token->rotation.matrix[0][0] = cospitch * cosyaw;
  token->rotation.matrix[0][1] = cospitch * sinyaw;
  token->rotation.matrix[0][2] = -1* sinpitch;
  token->rotation.matrix[0][3] = 0;
  token->rotation.matrix[1][0] = sinrollsinpitch * cosyaw - cosrollsinyaw;
  token->rotation.matrix[1][1] = sinrollsinpitch * sinyaw + cosroll*cospitch;
  token->rotation.matrix[1][2] = sinroll * cosyaw;
  token->rotation.matrix[1][3] = 0;
  token->rotation.matrix[2][0] = cosrollcosyaw * sinpitch + sinroll*sinyaw;
  token->rotation.matrix[2][1] = cosrollsinyaw * sinpitch - sinroll* cosyaw;
  token->rotation.matrix[2][2] = cosrollcosyaw;
  token->rotation.matrix[2][3] = 0;
  token->rotation.matrix[3][0] = 0;
  token->rotation.matrix[3][1] = 0;
  token->rotation.matrix[3][2] = 0;
  token->rotation.matrix[3][3] = 1;

}

/*
 *        Procedure Name: screen_active
 *          Return Value: whether the mouse mode is MOUSE_SCREEN_MODE and is 
 *                        currently active
 *       Input Variables: 
 *      Output Variables:
 *      Update Variables: 
 *      Global Variables: 
 *                        IDE_mouse_active_flag;
 *           Description: This function checks whether the mouse mode 
 *                        is MOUSE_SCREEN_MODE and is currently active.
 */

int screen_active()
{
 extern C_IDE_simulation_method C_ide_simulation_method;

 if (C_ide_simulation_method.mode == C_SCREEN) 
      return(1);
 else
      return(0);
}

/*         Global Variable: IDE_window_information
 *                           This variable stores the width and height of the
 *                           correspondent drawingarea;
 *                           This variable stores the width and height of the
 *                           current active drawingarea;
 *                          IDE_device_allocation
 *                           This variable keeps the virtual device number for
 *                           the correspondent drawingarea;
 */

int                             IDE_device_allocation[C_MAX_WINDOW_NUMBER];


/*
 *        Procedure Name:   C_add_proc 
 *          Return Value:   void
 *       Input Variables:   window_index 
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:   IDE_active_config
 *           Description:   This function define the current active window
 *                          information
 */

void C_add_proc(window_index)
int window_index;
{
  IDE_active_config = IDE_VD_configuration
                      [ IDE_device_allocation [window_index]];
}

/*         Global Variable: IDE_current_window_number
 *                           This variable keeps total number of current
 *                           drawingareas.
 */ 

int IDE_current_window_number = 0;

/*
 *        Procedure Name:   C_tokenizer_c
 *          Return Value:   void
 *       Input Variables:   width and height of the drawingarea 
 *      Output Variables:
 *      Update Variables:   IDE_device_allocation;
 *                          IDE_window_information;
 *      Global Variables:   IDE_device_allocation;
 *                          IDE_window_information; 
 *           Description:   Part of the virtual device initilaization code.(C) 
 */


void C_tokenizer_c()
{
  IDE_device_allocation[IDE_current_window_number] = IDE_DEFAULT;
}

  







