/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: C_ide_selection.c
 *                  Author: He, Taosong
 *                  Date: 1/19/93
 *           Description: The C routines of selection queue operations
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/

#include <varargs.h>
#include <stdio.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_ide.h"

/*               Global variable: head_win, tail_win
 *                                  window event queue for each drawingarea;
 *                                head_sel, tail_sel
 *                                  selection queue for each drawingarea;
 */

C_WindowQ *head_win[C_MAX_WINDOW_NUMBER],*tail_win[C_MAX_WINDOW_NUMBER];
C_SelectionQ *head_sel[C_MAX_WINDOW_NUMBER],*tail_sel[C_MAX_WINDOW_NUMBER];

void C_insert_select_c(sel_device, window_index, operation_number)
int sel_device;
int window_index;
int operation_number;
{
        extern     int              IDE_current_window_number;
        extern     int              IDE_device_allocation[C_MAX_WINDOW_NUMBER];

        extern C_IDE_VD_configuration  IDE_VD_configuration [ C_MAX_VD_NUMBER];

        int C_get_select_number();

        int temp1;

        C_SelectionQ *temp;
        C_IDE_VD_configuration          sel;
        int              i;


        sel = IDE_VD_configuration[IDE_device_allocation [window_index]];

        for (i=0; i<C_MAX_SELECTION_NUMBER; i++)
         {
           if ( (sel.selection[i].source_device == sel_device)
              &&(sel.selection[i].operation_number == operation_number) )
               {
                 if (head_sel[window_index]==NULL)
                {
                  temp=(C_SelectionQ *)malloc(sizeof(C_SelectionQ));
                  temp->selection=i+1;
                  temp->next=NULL;
                  head_sel[window_index]=tail_sel[window_index]=temp;
                }
               else
                {
                  temp=(C_SelectionQ *)malloc(sizeof(C_SelectionQ));
                  temp->selection=i+1;
                  temp->next=NULL;
                  tail_sel[window_index]->next=temp;
                  tail_sel[window_index]=temp;
                }
                break;
              }
          }
}
 
/*
 *        Procedure Name: C_get_select_number
 *          Return Value: the selection number at the head of the queue
 *       Input Variables: selection queue index;
 *                        include_sel: to indicate whether to get the common
 *                                     selection event or special selection
 *                                     event. (session signal & panel signal)
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: get the header of the selection queue
 */

int C_get_select_number(window_index, include_sel)
int          window_index;
int          include_sel;
{
  C_SelectionQ *temp, *temp1;
  int          value;


  if (window_index == -1)
    {
       printf("\n Can not get sel from this window \n");
       return(-1);
    }

  if (head_sel[window_index]==NULL)
     return(-1);

   if (tail_sel[window_index] == head_sel[window_index])
   {
      if ( ( (head_sel[window_index]->selection == C_MAX_SELECTION_NUMBER) &&
              include_sel) ||
           ( (head_sel[window_index]->selection != C_MAX_SELECTION_NUMBER) &&
              !include_sel) )
      {
           value = head_sel[window_index]->selection;
           tail_sel[window_index]=head_sel[window_index]=NULL;
           return(value);
      }
     else
      return(-1);
   }

    if ( ( (head_sel[window_index]->selection == C_MAX_SELECTION_NUMBER) &&
              include_sel) ||
           ( (head_sel[window_index]->selection != C_MAX_SELECTION_NUMBER) &&
              !include_sel) )
      { 
           value = head_sel[window_index]->selection;
           head_sel[window_index]= head_sel[window_index]->next;
       return(value);
     }

   temp = head_sel[window_index];
   temp1 = head_sel[window_index]->next;
   while (((temp1->selection == C_MAX_SELECTION_NUMBER)   && !include_sel)
       || ((temp1->selection != C_MAX_SELECTION_NUMBER) && include_sel))
      {
        if (temp1 == tail_sel[window_index]) return(-1);
        temp = temp1;
        temp1 = temp1->next;
      }

    temp->next = temp1->next;
    if (temp1 == tail_sel[window_index])
           tail_sel[window_index] = temp;
    value = temp1->selection;
    free(temp1);
    return(value);
}

/*
 *        Procedure Name: C_get_window_c
 *          Return Value:
 *       Input Variables: index of window event queues
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: Get the header of the window event queue(C code)
 */

int C_get_window_c(window_index)
int window_index;
{
  int         win_event;
  C_WindowQ   *temp;

  if (window_index == -1)
    {
       printf("\n Can not get sel from this window \n");
       return(-1);
    }

  if (head_win[window_index]==NULL)
     return(-1);
  if (tail_win[window_index]==head_win[window_index])
   {
     win_event=head_win[window_index]->win_event;
     tail_win[window_index]=head_win[window_index]=NULL;
   }
  else
   {
     win_event=head_win[window_index]->win_event;
     temp=head_win[window_index];
     head_win[window_index]=head_win[window_index]->next;
     free(temp);
   }
  return(win_event);
}

/*
 *        Procedure Name: C_insert_window_c
 *          Return Value:
 *       Input Variables: index of window event queues
 *                        name of the window event: window_event
 *      Output Variables:
 *      Update Variables:
 *      Global Variables:
 *           Description: insert an window event to the
 *                        specific window event queue(C code)
 */

void C_insert_window_c(window_index, window_event)
int window_index;
int window_event;
{
C_WindowQ *temp;

          if (head_win[window_index]==NULL) {
           temp=(C_WindowQ *)malloc(sizeof(C_WindowQ));
           temp->win_event=window_event;
           temp->next=NULL;
           head_win[window_index]=tail_win[window_index]=temp;
                                             }
         else {
           temp=(C_WindowQ *)malloc(sizeof(C_WindowQ));
           temp->win_event=window_event;
           tail_win[window_index]->next=temp;
           tail_win[window_index]=temp;
              }
}

void C_copy_selection()
{
  extern C_IDE_VD_configuration IDE_VD_configuration[C_MAX_VD_NUMBER];

  int j;

  for (j = 0; j< C_MAX_VD_NUMBER; j++)
     {
          IDE_VD_configuration[j] = IDE_VD_configuration[IDE_DEFAULT];
     }
}

void C_init_selection(device, vdnumber)
int device;
int vdnumber;
{
  extern C_IDE_VD_configuration IDE_VD_configuration[C_MAX_VD_NUMBER];

  int i, j;

  for (i=0; i < C_MAX_SELECTION_NUMBER; i++)
       {
          IDE_VD_configuration[vdnumber].selection[i].source_device = -1;
          IDE_VD_configuration[vdnumber].selection[i].operation_number = 0;
       }

  switch (device)
   {
    case C_MOUSE:
    case C_DATAGLOVE:

      IDE_VD_configuration[vdnumber].selection[0].source_device = C_KEYBOARD;
      IDE_VD_configuration[vdnumber].selection[0].operation_number = 0;

      IDE_VD_configuration[vdnumber].selection[1].source_device = C_KEYBOARD;
      IDE_VD_configuration[vdnumber].selection[1].operation_number = 1;

      IDE_VD_configuration[vdnumber].selection[2].source_device = C_MOUSE;
      IDE_VD_configuration[vdnumber].selection[2].operation_number = 1;

      IDE_VD_configuration[vdnumber].selection[3].source_device = C_MOUSE;
      IDE_VD_configuration[vdnumber].selection[3].operation_number = 2;
  
      IDE_VD_configuration[vdnumber].selection[C_MAX_SELECTION_NUMBER-1].source_device = C_MOUSE;
      IDE_VD_configuration[vdnumber].selection[C_MAX_SELECTION_NUMBER-1].operation_number = 0;

      break;

    case C_SPACEBALL:

      IDE_VD_configuration[vdnumber].selection[C_MAX_SELECTION_NUMBER-1].source_device = C_SPACEBALL;
      IDE_VD_configuration[vdnumber].selection[C_MAX_SELECTION_NUMBER-1].operation_number = SPACEBALL_BUTPICK;
     
      break;

    default:

      break;
     }
}
     



  
           

