/* display routines for showpix */

#include "showpix.h"

#define pixred(xoff, lin) ( \
        ((imagetype(im)==PIX_CMAP) || (imagetype(im)==PIX_RLECMAP)) ? \
        (im->red[ r[lin][xoff] ]) : ( r[lin][xoff]) )
#define pixgreen(xoff, lin) ( \
        ((imagetype(im)==PIX_CMAP) || (imagetype(im)==PIX_RLECMAP)) ? \
        (im->green[ r[lin][xoff] ]) : ( g[lin][xoff]) )
#define pixblue(xoff, lin) ( \
        ((imagetype(im)==PIX_CMAP) || (imagetype(im)==PIX_RLECMAP)) ? \
        (im->blue[ r[lin][xoff] ]) : ( b[lin][xoff]) )



/* colour map info */
int cmap_size = PALETTE_SIZE;
int paltype;
int pattern[6][3]= { {0, 1, 2}, {1, 2, 0},
                     {2, 0, 1}, {0, 2, 1},
                     {2, 1, 0}, {1, 0, 2} };
int trkyd[10];
int trkysshift;
int hgt, wdt;


int setvideostats(int mode)
{
    if ((mode<1)||(mode>MAXVIDEO))
         return -1;

    mode--;

    dismode=videos[mode][0];
    disxw=videos[mode][1];
    disyw=videos[mode][2];

    return 1;
}


/* paltype==0 ->external    1 ->64-shades      2 ->square trick  */


void make_palette(void)
{
        int i, r1, g1, b1, drk;
        long int intensity, darkest=0x7FFFFFFF;

        paltype=1;
        if (imagetype(im)==PIX_CMAP || imagetype(im)==PIX_RLECMAP &&
            options==FULLCOLORS)
              paltype=0;

        if (options==TRICKYS || options==TRICKY2S)
              paltype=2;

        switch(paltype) {

        case 0:
              /* set up colour palette for colour map files */
              for (i = 0; i < cmapsize(im); i++) {
                   /* 6-bits only per value please */
                   r1 = dacbox[i][0]=im->red[i] >> 2;
                   g1 = dacbox[i][1]=im->green[i] >> 2;
                   b1 = dacbox[i][2]=im->blue[i] >> 2;
                   /* check if this colour is darker than previous darkest */
                   intensity=(r1*r1 + g1*g1 + b1*b1);
                   if (intensity<darkest) {
                        darkest=intensity;
                        drk=i;
                        }
                   }
              cmap_size = cmapsize(im);
              break;

        case 1:
              /* set up a 64-shades palette */

              for (i=0; i<64; i++) {
                   dacbox[i][0]=i;
                   dacbox[i][1]=i;
                   dacbox[i][2]=i;

                   dacbox[64+i][0]=i;
                   dacbox[64+i][1]=0;
                   dacbox[64+i][2]=0;

                   dacbox[128+i][0]=0;
                   dacbox[128+i][1]=i;
                   dacbox[128+i][2]=0;

                   dacbox[192+i][0]=0;
                   dacbox[192+i][1]=0;
                   dacbox[192+i][2]=i;
                   }

              cmap_size=256;
              break;

        case 2:
              /* altered 64-shades palette */
              for (i=0; i<64; i++) {
                   dacbox[i][0]=i*50/63;
                   dacbox[i][1]=i*50/63;
                   dacbox[i][2]=i*38/63;

                   dacbox[64+i][0]=i;
                   dacbox[64+i][1]=0;
                   dacbox[64+i][2]=0;

                   dacbox[128+i][0]=0;
                   dacbox[128+i][1]=i;
                   dacbox[128+i][2]=0;

                   dacbox[192+i][0]=0;
                   dacbox[192+i][1]=0;
                   dacbox[192+i][2]=i;
                   }

              cmap_size=256;
              break;
              }
}



void inittrick(int xc)
{
    int i, v;

    if (options==TRICKYL) {
         v=xc % 3;
         for (i=0; i<tricklen; i++)
              if (trickyd[i]<3)
                   trkyd[i]= (trickyd[i] + v) % 3;
              else
                   trkyd[i]= 3 + (trickyd[i] + v) % 3;
         }
    else
         trkysshift=xc&1;

}




void convertlines(int yc, int begr, int begw)
{
    int i, to1, to2, v1, v2, v3, c[4];
    unsigned int vi1, vi2;

    if (paltype==0) {   /* external, do nothing */
         for (i=0; i<wdt; i++) {
              s[0][begw]=r[0][begr];
              s[1][begw++]=r[1][begr++];  /* just copy */
              }

         return;
         }

    if (options!=TRICKYL && options!=TRICKYS && options!=TRICKY2S) {
         for (i=0; i<wdt; i++) {
              switch(options) {
              case REDPLANE:
                   vi1=pixred(begr, 0);
                   vi1=64+(vi1>>2);
                   vi2=pixred(begr, 1);
                   vi2=64+(vi2>>2);
                   break;

              case GREENPLANE:
                   vi1=pixgreen(begr, 0);
                   vi1=128+(vi1>>2);
                   vi2=pixgreen(begr, 1);
                   vi2=128+(vi2>>2);
                   break;

              case BLUEPLANE:
                   vi1=pixblue(begr, 0);
                   vi1=192+(vi1>>2);
                   vi2=pixblue(begr, 1);
                   vi2=192+(vi2>>2);
                   break;

              case FULLCOLORS:
              case MONOCHROME:
                   vi1=90*(unsigned int) pixred(begr, 0);
                   vi1+=140*(unsigned int) pixgreen(begr, 0);
                   vi1+=25*(unsigned int) pixblue(begr, 0);
                   vi1=(int)(vi1>>10);
                   vi2=90*(unsigned int) pixred(begr, 1);
                   vi2+=140*(unsigned int) pixgreen(begr, 1);
                   vi2+=25*(unsigned int) pixblue(begr, 1);
                   vi2=(int)(vi2>>10);
                   break;
                   }

              s[0][begw]=vi1;
              s[1][begw++]=vi2;
              begr++;
              }

         return;
         }
    else {
         /* do the trick...... */
         for (i=0; i<wdt;) {
              v1=i;
              v2=i+1;
              v3=i+2;

              if (v1>=wdt)
                   v1=wdt;
              if (v2>=wdt)
                   v2=wdt;
              if (v3>=wdt)
                   v3=wdt;

              v1+=begr;
              v2+=begr;
              v3+=begr;

              switch(options) {
              case TRICKYL:
                   to1=trkyd[yc % tricklen];
                   to2=trkyd[(yc+1) % tricklen];

                   c[0]=pixred(v1, 0);
                   c[0]+=pixred(v2, 0);
                   c[0]+=pixred(v3, 0);
                   c[1]=pixgreen(v1, 0);
                   c[1]+=pixgreen(v2, 0);
                   c[1]+=pixgreen(v3, 0);
                   c[2]=pixblue(v1, 0);
                   c[2]+=pixblue(v2, 0);
                   c[2]+=pixblue(v3, 0);

                   c[0]/=12;
                   c[1]/=12;
                   c[2]/=12;

                   s[0][begw]=64*(1+pattern[to1][0])+c[pattern[to1][0]];
                   s[0][begw+1]=64*(1+pattern[to1][1])+c[pattern[to1][1]];
                   s[0][begw+2]=64*(1+pattern[to1][2])+c[pattern[to1][2]];

                   c[0]=pixred(v1, 1);
                   c[0]+=pixred(v2, 1);
                   c[0]+=pixred(v3, 1);
                   c[1]=pixgreen(v1, 1);
                   c[1]+=pixgreen(v2, 1);
                   c[1]+=pixgreen(v3, 1);
                   c[2]=pixblue(v1, 1);
                   c[2]+=pixblue(v2, 1);
                   c[2]+=pixblue(v3, 1);

                   c[0]/=12;
                   c[1]/=12;
                   c[2]/=12;

                   s[1][begw++]=64*(1+pattern[to2][0])+c[pattern[to2][0]];
                   s[1][begw++]=64*(1+pattern[to2][1])+c[pattern[to2][1]];
                   s[1][begw++]=64*(1+pattern[to2][2])+c[pattern[to2][2]];

                   i+=3;
                   break;

              case TRICKY2S:
                   c[0]=pixred(v1, 0);
                   c[0]/=4;
                   c[1]=pixgreen(v1, 0);
                   c[1]/=4;
                   c[2]=pixblue(v1, 0);
                   c[2]/=4;
                   c[3]=(c[0]+c[1]+c[2])/3;

                   if (trkysshift==0) {
                        s[0][begw]=c[0]+64;
                        s[1][begw++]=c[2]+192;
                        s[0][begw]=c[1]+128;
                        s[1][begw++]=c[3];
                        }
                   else {
                        s[0][begw]=c[1]+128;
                        s[1][begw++]=c[3];
                        s[0][begw]=c[0]+64;
                        s[1][begw++]=c[2]+192;
                        }

                   i++;
                   break;

              case TRICKYS:
                   c[0]=pixred(v1, 0);
                   c[0]+=pixred(v2, 0);
                   c[0]+=pixred(v1, 1);
                   c[0]+=pixred(v2, 1);
                   c[0]/=16;
                   c[1]=pixgreen(v1, 0);
                   c[1]+=pixgreen(v2, 0);
                   c[1]+=pixgreen(v1, 1);
                   c[1]+=pixgreen(v2, 1);
                   c[1]/=16;
                   c[2]=pixblue(v1, 0);
                   c[2]+=pixblue(v2, 0);
                   c[2]+=pixblue(v1, 1);
                   c[2]+=pixblue(v2, 1);
                   c[2]/=16;
                   c[3]=(c[0]+c[1]+c[2])/3;

                   if (trkysshift==0) {
                        s[0][begw]=c[0]+64;
                        s[1][begw++]=c[2]+192;
                        s[0][begw]=c[1]+128;
                        s[1][begw++]=c[3];
                        }
                   else {
                        s[0][begw]=c[1]+128;
                        s[1][begw++]=c[3];
                        s[0][begw]=c[0]+64;
                        s[1][begw++]=c[2]+192;
                        }

                   i+=2;
                   break;
                   }
              }
         }
}



int readlines(int yp)
{
    int dy=1;

    switch(imagetype(im)) {
    case PIX_CMAP :
    case PIX_RLECMAP :
         readmappedline(im, r[0]);
         if ((hgt&1) && yp==(hgt-1) || options==TRICKY2S)
              memcpy(r[1], r[0], wdt);
         else {
              readmappedline(im, r[1]);
              dy=2;
              }
         break;

    default :
         readrgbline(im, r[0], g[0], b[0]);
         if ((hgt&1) && yp==(hgt-1) || options==TRICKY2S) {
              memcpy(r[1], r[0], wdt);
              memcpy(g[1], g[0], wdt);
              memcpy(b[1], b[0], wdt);
              }
         else {
              readrgbline(im, r[1], g[1], b[1]);
              dy=2;
              }
         break;
         }

    return dy;
}



void display_image(int bx, int by, int shifted, int single)
{
        int x, y, px, py, dy=2;

        wdt = imagewidth(im);
        hgt = imageheight(im);

        if (!shifted && centering) {
              bx=(disxw-wdt)/2;
              by=(disyw-hgt)/2;
              }

        if (imagefragment(im)) {
              bx+=imagexaddr(im);
              by+=imageyaddr(im);
              }

        if (single) {
              for (x=0; x<MAX_IMGWIDTH*3; x++) {
                   s[0][x]=0;
                   s[1][x]=0;
                   }

              gotographics(dismode);
              /* remap palette */
              make_palette();
              storedac();
              }

        if (options==TRICKYL || options==TRICKYS || options==TRICKY2S)
              inittrick(bx);

        /* display image line by line */
        imagepos(im, 0, 0);
        switch (imagetype(im)) {

              case PIX_CMAP :
              case PIX_RLECMAP :
                   if (single) {
                        rowcount=by;
                        for (y = 0; (y<hgt && rowcount<disyw); y+=dy) {
                                dy=readlines(y);

                                if (rowcount>=0) {
                                     convertlines(y, 0, bx+1280);
                                     out_line(s[0]+1280, disxw);
                                     out_line(s[1]+1280, disxw);
                                     }
                                else
                                     rowcount++;
                                }
                        }
                   else {
                        for (y=0; y<hgt; y+=dy) {
                             dy=readlines(y);

                             py=y+by;
                             if (py>=0 && py<disyw) {
                                  convertlines(y, 0, 0);
                                  for (x=0; x<wdt; x++) {
                                       px=x+bx;
                                       if (px>=0 && px<disxw) {
                                            putcolor(px, py, s[0][x]);
                                            putcolor(px, py+1, s[1][x]);
                                            }
                                       }
                                  }
                             }
                        }
                   break;

              default :
                   if (single) {
                        rowcount=by;
                        for (y = 0; (y<hgt && rowcount<disyw); y+=dy) {
                                dy=readlines(y);

                                if (rowcount>=0) {
                                     convertlines(y, 0, 1280+bx);
                                     out_line(s[0]+1280, disxw);
                                     out_line(s[1]+1280, disxw);
                                     }
                                else
                                     rowcount++;
                                }
                        }
                   else {
                        for (y=0; y<hgt; y+=dy) {
                             dy=readlines(y);

                             py=y+by;
                             if (py>=0 && py<disyw) {
                                  convertlines(y, 0, 0);
                                  for (x=0; x<wdt; x++) {
                                       px=x+bx;
                                       if (px>=0 && px<disxw) {
                                            putcolor(px, py, s[0][x]);
                                            putcolor(px, py+1, s[1][x]);
                                            }
                                       }
                                  }
                             }
                        }
                   break;
                }
        closeimage(im);
}
