/*
 * VGA 320 x 400 display routine for VORT PCDISP.
 *
 * Only works fairly simply. No EMS handling or arbitrary
 * image positioning.
 *
 * Uses external routines defined in 320x400.asm:
 *		
 *		Set320x400Mode();
 *		Out320x400Line();
 *		Page320x400();
 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <memory.h>
#include "pcdisp.h"


int		vega_palette();
int		vega_overscan();

static vga320x400_init();
static vga320x400_line();
static vga320x400_block();
static vga320x400_erase();
static vga320x400_front();
static vga320x400_back();
static vga320x400_swap();
static vga320x400_text();
	

static	ADAPTER	vga320x400 = {
			"VGA 320 x 400, 256 colour",
			320,
			400,
			8,
			0, 0,
			0,
			vga320x400_init,
			vga320x400_line,
			NULL,
			NULL,
			vga320x400_block,
			vga320x400_erase,
			vega_palette,
			vega_overscan,
			vga320x400_front,
			vga320x400_back,
			vga320x400_swap,
			vga320x400_text,
			NULL,
			NULL,
			};

/* for doing system stuff */
static	union	REGS	regs;
static	struct	SREGS	segregs;


/* video buffer flag: == 0 front buffer; != 0 back buffer */
static	int		to_back_buffer = 0;

/* static buffer for performing erases of a line */
static	char	line[320];

int			setup_vga320x400(a)
ADAPTER		*a;
{
	memmove(a, &vga320x400, sizeof(vga320x400));
	return 1;
}


static
int			vga320x400_init()
{
	Set320x400Mode();
}


static
int			vga320x400_line(p, l, x, y)
char		*p;
int			l,
			x,
			y;
{
	Out320x400Line(y, p, l, to_back_buffer);
}


static
int			vga320x400_block(p, w, h, x, y)
char		*p;
int			w,
			h,
			x,
			y;
{
	int		i, w1;

	/* ensure everything is in range */
	if (w + x > 320) w1 = 320 - x;
	else w1 = w;
	if (h + y > 400) h = 400 - y;

	/* output line by line - doesn't handle x offset */
	for (i = 0; i < h; i++) {
		Out320x400Line(y+i, p, w1, to_back_buffer);
		p += w;
		}
}


static
int			vga320x400_erase(x, y, w, h, palette_index)
{
	int		j;

	/* ignore x and w parameters since our line output routine doesn't */
	/* yet handle specification of start and end x-coords! */
	memset(line, palette_index, 400);
	for (j = 0; j < h; j++) Out320x400Line(j, line, 400, to_back_buffer);
}


static
int			vga320x400_front()
{
	to_back_buffer = 0;
}


static
int			vga320x400_back()
{
	to_back_buffer = 1;
}


static
int			vga320x400_swap()
{
	page320x400(to_back_buffer);
	to_back_buffer = !to_back_buffer;
}


static
int			vga320x400_text(p, x, y)
char		*p;
int			x,
			y;
{
}

