#include <stdio.h>
#include "vort.h"

/*
 * readmappedline
 *
 *	reads in a scanline for a colour mapped image as the
 * colourmap indexes.
 */
int
readmappedline(in, line)
	image		*in;
	unsigned char	*line;
{
	register int	x, i;
	unsigned char	run;

	switch (imagetype(in)) {
	case PIX_CMAP:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			line[x] = i;
		}
		break;
	case PIX_RLECMAP:
		x = 0;
		while (x < imagewidth(in)) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			run = i;
			if (run & 0x80) {
				while ((run & 0x7f) && x < imagewidth(in)) {
					i = readbyte(in);
					line[x] = i;
					run--;
					x++;
				}
			} else {
				i = readbyte(in);
				line[x] = i;
				x++;
				while (run && x < imagewidth(in)) {
					line[x] = i;
					run--;
					x++;
				}
			}
		}
		break;
	default:
		fprintf(stderr, "readmappedline: bad file format.\n");
		return(0);
	}

	return(1);
}
