#include <stdio.h>
#include <math.h>
#ifdef MSC
#include <fcntl.h>
#else
#ifdef SYSV
#include <fcntl.h>
#else
#ifdef VMS
#include <file.h>
#else
#include <sys/file.h>
#endif
#endif
#endif
#include "art.h"
#include "gram.h"
#include "macro.h"

extern attr	*astackp;

extern symbol	*findsym(), *insertsym();

static symbol	*tiles = NULL;

#ifdef PC
extern int	EMS_available;
#endif

/*
 * tileinit
 *
 *	initialise the function pointers and fields for a tile pattern. 
 */
void
#ifdef PC
tileinit(name, map, pixw, pixh, EMS_h, EMS_ofs)
	char		*name;
	char		**map;
	unsigned short	*pixw, *pixh;
	unsigned int	*EMS_h;
	unsigned long	*EMS_ofs;
#else
tileinit(name, map, pixw, pixh)
	char		*name;
	char		**map;
	unsigned short	*pixw, *pixh;
#endif	
{
	register	int	i;
	image	*im;
	symbol	*sym;
	char	 *red, *green, *blue, buf[BUFSIZ], *cp;
#ifdef PC
	unsigned int	EMS_page, ep;
	unsigned char far *EMS_addr;
#endif

	if ((sym = findsym(tiles, name)) != (symbol *)NULL) {
		*pixw = sym->u.tile.width;
		*pixh = sym->u.tile.height;
		*map = sym->u.tile.pic;
#ifdef PC
		*EMS_h = sym->u.tile.EMS_h;
		*EMS_ofs = sym->u.tile.EMS_ofs;
#endif
		return;
	}

	if ((im = openimage(name, "r")) == (image *)NULL) {
		sprintf(buf, "art: error opening tile file %s.\n", name);
		fatal(buf);
	}

	sym = insertsym(&tiles, name);

	*pixw = sym->u.tile.width = imagewidth(im);
	*pixh = sym->u.tile.height = imageheight(im);

	red = (char *)smalloc(imagewidth(im));
	green = (char *)smalloc(imagewidth(im));
	blue = (char *)smalloc(imagewidth(im));

#ifdef PC
	if (EMS_available) {
		if ((*EMS_h = EMS_alloc(((*pixw * (unsigned long)*pixh * 3L) / EMS_PAGE_SIZE)+1)) != EMS_NULL_HDL) {
			/* we have allocated enough EMS for this tile pattern, use it */
			sym->u.tile.EMS_h = *EMS_h;
			sym->u.tile.EMS_ofs = 0L;
			*map = NULL;
			sym->u.tile.pic = NULL;
			ep = 0;
			EMS_page = 0;
			EMS_addr = EMS_base();
			EMS_map(*EMS_h, EMS_page);

			while (readrgbline(im, red, green, blue)) {
				for (i = 0; i < imagewidth(im); i++) {
					EMS_addr[ep] = red[i];
					if (++ep >= EMS_PAGE_SIZE) {EMS_map(*EMS_h, ++EMS_page); ep = 0;}
					EMS_addr[ep] = green[i];
					if (++ep >= EMS_PAGE_SIZE) {EMS_map(*EMS_h, ++EMS_page); ep = 0;}
					EMS_addr[ep] = blue[i];
					if (++ep >= EMS_PAGE_SIZE) {EMS_map(*EMS_h, ++EMS_page); ep = 0;}
				}
			}

			closeimage(im);
			free(red);
			free(green);
			free(blue);
			return;
		}
	}
	sym->u.tile.EMS_h = *EMS_h = EMS_NULL_HDL;

	/* check if image size is to big for a PC (MSC) */
#endif

	cp = *map = sym->u.tile.pic = (char *)scalloc(imagewidth(im), (unsigned long)imageheight(im) * 3);

	while (readrgbline(im, red, green, blue))
		for (i = 0; i < imagewidth(im); i++) {
			*cp++ = red[i];
			*cp++ = green[i];
			*cp++ = blue[i];
		}

	closeimage(im);
	free(red);
	free(green);
	free(blue);
}


#ifdef PC
/*
 * Walk the tile symbol tree and deallocate any used EMS.
 */
int   	uninit_tiles()
{
	uninit_a_tile(tiles);
}


int		uninit_a_tile(boffo)
symbol	*boffo;
{
	if (boffo) {
		if (boffo->left) uninit_a_tile(boffo->left);
		else if (boffo->right) uninit_a_tile(boffo->right);
		EMS_release(boffo->u.tile.EMS_h);
	}
}

#endif
