#include <stdio.h>
#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/pad.ins.c"
#include "/sys/ins/kbd.ins.c"
#include "vort.h"

#define	SETSIZE			(short)3
#define	CMAPSIZE		256
#define COLOR_ENTRY(r, g, b)	(gpr_$pixel_value_t) ((r << 16) | (g << 8) | b)
static	int			mapsize;

static	gpr_$pixel_value_t  	color_value[CMAPSIZE];
static	gpr_$pixel_value_t  	old_color_map[CMAPSIZE];
static	status_$t		status;


/*
 * program to read in a color-mapped image and display it on the apollo
 */
main(ac, av)
	int	ac;
	char	**av;
{
	gpr_$event_t     	et;
	char     	        ed;
	gpr_$position_t  	pos;
	gpr_$keyset_t        	keys;

	pad_$window_desc_t	window;
	ios_$id_t		stream_id;

	gpr_$display_mode_t	mode = gpr_$direct;
	gpr_$rgb_plane_t	hi_plane;
	gpr_$offset_t		display_size;
	gpr_$bitmap_desc_t	display_bm;
	gpr_$bitmap_desc_t	mem_bm;
	gpr_$attribute_desc_t	attrib;
	gpr_$window_t		source;
	gpr_$position_t		dest_pos;
	gpr_$disp_char_t	disp_characteristics;
	gpr_$pixel_value_t	start_index = 0;

	static	short	int	disp_len = sizeof(gpr_$disp_char_t);
	static	short	int	disp_len_returned, invisible = 0;
	

	register int	i, x, y;
	unsigned short	h, w;
	int		val;
	unsigned char	*line, *red, *green, *blue;
	image		*im;

	if (ac != 2) {
		fprintf(stderr, "disp: usage disp file.\n");
		exit(1);
	}

	if ((im = openimage(av[1], "r")) == (image *)NULL) {
		fprintf(stderr, "disp: can't open file %s.\n", av[1]);
		exit(1);
	}

	/*
	 * Determine display characteristics
	 */

	gpr_$inq_disp_characteristics(mode,
		1,
		disp_len,
		disp_characteristics, 
		disp_len_returned,
		status
	);

	hi_plane = disp_characteristics.n_planes - 1;

	window.top = 0;
	window.left = 0;
	window.width = w = imagewidth(im);
	window.height = h = imageheight(im);

	window.width += 5;
	window.height += 25;

	pad_$create_window("", 0,
			pad_$transcript,
			1,
			window,
			stream_id,
			status
	);

	if (w > 128 && h > 128) {
		fprintf(stderr, "This might take some time....\n");
		pad_$make_invisible(stream_id, 1, status);
		invisible = 1;
	}

	pad_$set_auto_close(stream_id, 1, true, status);

	display_size.x_size = w;
	display_size.y_size = h;

	source.window_base.x_coord = 0;
	source.window_base.y_coord = 0;
	source.window_size.x_size = w;
	source.window_size.y_size = h;
	dest_pos.x_coord = 0;
	dest_pos.y_coord = 0;

	gpr_$init(mode,
		stream_id,
		display_size,
		hi_plane,
		display_bm,
		status
	);

	gpr_$allocate_attribute_block(attrib, status);
	gpr_$allocate_bitmap(display_size, hi_plane, attrib, mem_bm, status);
	gpr_$set_bitmap(mem_bm, status);

	gpr_$set_auto_refresh(true, status);
	gpr_$set_cursor_active(true, status);

	/*
	 * Get the colormap
	 */
	gpr_$inq_color_map(start_index,
		(short)CMAPSIZE,
		old_color_map,
		status
	);


	y = 0;

	line = (unsigned char *)malloc(w);

	if (colormapped(im)) {
		mapsize = cmapsize(im);
		for (i = 0; i < mapsize; i++)
			color_value[i] = COLOR_ENTRY(
						redmap(im)[i],
						greenmap(im)[i],
						bluemap(im)[i]
					 );

		while (y < h) {
			if (invisible && !(y % 50))
				fprintf(stderr, "Done %d of %d\n", y + 1, h);

			readmappedline(im, line);
			gpr_$move((short)0, (short)y, status);
			for (x = 0; x < w; x++) {
				gpr_$set_draw_value((int)line[x], status);
				gpr_$line((short)x, (short)y, status);
			}
			y++;
		}

	} else {
		mapsize = CMAPSIZE;
		red = (unsigned char *)malloc(w);
		green = (unsigned char *)malloc(w);
		blue = (unsigned char *)malloc(w);

		for (i = 0; i < CMAPSIZE; i++)
			color_value[i] = COLOR_ENTRY(i, i, i);

		while (y < h) {
			if (invisible && !(y % 50))
				fprintf(stderr, "Done %d of %d\n", y + 1, h);

			readrgbline(im, red, green, blue);
			gpr_$move((short)0, (short)y, status);
			for (x = 0; x < w; x++) {
				val = red[x] * 0.3 + green[x] * 0.59 + blue[x] * 0.11;
				gpr_$set_draw_value((int)val, status);
				gpr_$line((short)x, (short)y, status);
			}
			y++;
		}
	}

	if (invisible) 
		pad_$select_window(stream_id, 1, status);

	gpr_$acquire_display(status);

	gpr_$set_color_map(start_index,
		    (short)mapsize,
		    color_value,
		    status
	);

	gpr_$set_bitmap(display_bm, status);
	gpr_$pixel_blt(mem_bm, source, dest_pos, status);
	gpr_$release_display(status);

	/*  
	 * Create a key set for the event interupts  
	 * The program waits until one of the mouse buttons
	 * is clicked.
	 */

	lib_$init_set(keys, SETSIZE);

	lib_$add_to_set(keys, SETSIZE, KBD_$M1U);
	lib_$add_to_set(keys, SETSIZE, KBD_$M2U);
	lib_$add_to_set(keys, SETSIZE, KBD_$M3U);

	gpr_$enable_input(gpr_$buttons, keys, status);

	(void)gpr_$event_wait(et, ed, pos, status);

	/*
	 * Restore the old color map...
	 */
	gpr_$acquire_display(status);
	gpr_$set_color_map(start_index,
		    (short)CMAPSIZE,
		    old_color_map,
		    status
	);
	gpr_$release_display(status);

	gpr_$terminate(false, status);

	exit(0);
}
