#include <math.h>
#include <stdio.h>
#include <vogle.h>
#include "art.h"
#include "macro.h"
#include "gram.h"


extern mats	*mstackp;
extern hlist	*fhlist;
extern float	tolerance;
extern int	lookatdone;
extern int	longlines;

/*
 * cylinit
 *
 *	initialise the function pointers and fields of a cylinder object
 */
cylinit(o, d)
	object	*o;
	details *d;
{
	int	first;
	vector	c1, c2, rad;
	details	*ld;
	float	apex_x, apex_y, apex_z, apex_r;
	float	base_x, base_y, base_z, base_r;
	float	len0, len1,  len_x, len_y, len_z;
	float	cosine, sine, dx1, dy1, dx2, dy2, delta;
	float	cx1, cy1, cx2, cy2;
	int	i;
	Matrix	m;

	if (!lookatdone)
		deflookat();

	first = 1;

	rad.x = rad.y = 1.0;

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
			if (first) {
				c1 = d->u.v;
				first = 0;
			} else {
				c2 = d->u.v;
			}
			break;
		case RADIUS:
			rad.x = rad.y = d->u.f;
			break;
		case RADII:
			rad.x = d->u.v.x;
			rad.y = d->u.v.y;
			break;
		default:
			warning("art: illegal field in cylinder ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}


	len_x = c1.x - c2.x;
	len_y = c1.y - c2.y;
	len_z = c1.z - c2.z;

	len0 = sqrt(len_x * len_x + len_y * len_y + len_z * len_z);

	len1 = sqrt(len_x * len_x + len_z * len_z);

	pushmatrix();

	calctransforms(mstackp);
	multmatrix(mstackp->obj2ray);

	/*
	 * Draw the axis center line in YELLOW
	 */
	color(YELLOW);
	move(c1.x, c1.y, c1.z);
	draw(c2.x, c2.y, c2.z);

	/*
	 * And the rest in GREEN...
	 */
	color(GREEN);

	pushmatrix();

		translate(c2.x, c2.y, c2.z);

		identmatrix(m);

		if (len1 == 0.0) {
			cosine = 0.0;
			sine = 1.0;
		} else {
			cosine = len_z / len1;
			sine = len_x / len1;
		}

		/* rotate about y */
		m[0][0] = cosine;
		m[0][2] = -sine;
		m[2][0] = sine;
		m[2][2] = cosine;
		multmatrix(m);

		identmatrix(m);

		if (len0 == 0.0) {
			cosine = 0.0;
			sine = 1.0;
		} else {
			cosine = len1 / len0;
			sine = -len_y / len0;
		}

		/* rotate about x */
		m[1][1] = cosine;
		m[1][2] = sine;
		m[2][1] = -sine;
		m[2][2] = cosine;
		multmatrix(m);

		/*
		 * Draw the end circles...
		 */
		pushmatrix();
			scale(rad.x, rad.y, 1.0);

			circle (0.0, 0.0, 1.0);

			pushmatrix();
				translate(0.0, 0.0, len0);
				circle (0.0, 0.0, 1.0);
			popmatrix();
		popmatrix();



		/*
		 * Draw the logitudinal lines...
		 */
		delta = 2 * PI / longlines;

		cosine = cos(delta);
		sine = sin(delta);

		cx1 = rad.x;
		cy1 = 0.0;
		cx2 = rad.x;
		cy2 = 0.0;

		move(cx1, cy1, 0.0);
		draw(cx2, cy2, len0);

		for (i = 0; i < longlines; i++) {
			dx1 = cx1;
			dy1 = cy1;
			cx1 = dx1 * cosine - dy1 * sine;
			cy1 = dx1 * sine + dy1 * cosine;
			dx2 = cx2;
			dy2 = cy2;
			cx2 = dx2 * cosine - dy2 * sine;
			cy2 = dx2 * sine + dy2 * cosine;
			move(cx1, cy1, 0.0);
			draw(cx2, cy2, len0);
		}
	popmatrix();

	popmatrix();
}
