#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern mats	*mstackp;
extern hlist	*fhlist;
extern float	tolerance;

extern int	lookatdone;

/*
 * boxinit
 *
 *	initialise the function pointers and extra field for a box object
 */
void
boxinit(o, d)
	object	*o;
	details *d;
{
	int	first;
	vector	c1, c2, max, min;
	details	*ld;

	c1.x = c1.y = c1.z = 0.0;		/* default box */
	c2.x = c2.y = c2.z = 1.0;

	first = 1;

	if (!lookatdone)
		deflookat();

	while (d != (details *)NULL) {
		switch (d->type) {
		case VERTEX:
			if (first) {
				c1 = d->u.v;
				first = 0;
			} else 
				c2 = d->u.v;
			break;
		default:
			warning("art: illegal field in box ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	if (c1.x > c2.x) {
		max.x = c1.x;
		min.x = c2.x;
	} else {
		max.x = c2.x;
		min.x = c1.x;
	}

	if (c1.y > c2.y) {
		max.y = c1.y;
		min.y = c2.y;
	} else {
		max.y = c2.y;
		min.y = c1.y;
	}

	if (c1.z > c2.z) {
		max.z = c1.z;
		min.z = c2.z;
	} else {
		max.z = c2.z;
		min.z = c1.z;
	}

	pushmatrix();

		calctransforms(mstackp);
		multmatrix(mstackp->obj2ray);

		move(min.x, min.y, min.z);
		draw(max.x, min.y, min.z);
		draw(max.x, max.y, min.z);
		draw(min.x, max.y, min.z);
		draw(min.x, min.y, min.z);

		move(min.x, min.y, max.z);
		draw(max.x, min.y, max.z);
		draw(max.x, max.y, max.z);
		draw(min.x, max.y, max.z);
		draw(min.x, min.y, max.z);

		move(min.x, min.y, max.z);
		draw(min.x, min.y, min.z);

		move(max.x, max.y, max.z);
		draw(max.x, max.y, min.z);

		move(min.x, max.y, max.z);
		draw(min.x, max.y, min.z);

		move(max.x, min.y, max.z);
		draw(max.x, min.y, min.z);
	
	popmatrix();
}
