/*
 * Copyright (c) 1990,1,2 Mark Nitzberg
 * and President and Fellows of Harvard College
 * All rights reserved.
 */

#include <math.h>

/*
 * Draw 1-D gaussian lookalike with tails neatly splined to 0.
 * Note that for n < 8*sdev, the tails won't reach 0 at the boundaries.
 */
DrawGauSpline1D(arr, n, sdev)
float  *arr;
int     n;
float   sdev;
{
    double  k0, kl, kr, kll, krr;
    double  a, b, sum, c1, c2;
    register int x;

    /* constants */
    c1 = 16.0 * exp(2.0);
    c2 = 2.0 * sdev * sdev;

    /* define the knots to be at -2sdev & +2sdev */
    k0 = ((double) (n - 1.0)) / 2.0;
    kl = k0 - 2.0 * sdev;
    kll = k0 - 4.0 * sdev;
    kr = k0 + 2.0 * sdev;
    krr = k0 + 4.0 * sdev;

    /* construct the 1d curve */
    sum = 0.0;
    for (x = 0; x < n; x++) {

	/* put origin at k0 */
	a = x - k0;

	/* near 0 use the gaussian */
	if (kl <= x && x <= kr)
	    arr[x] = exp(-a * a / c2);

	/* else use the spline */
	else if (kll <= x && x < kl) {
	    b = 4.0 + a / sdev;
	    arr[x] = (b * b * b * b) / c1;
	} else if (kr < x && x <= krr) {
	    b = 4.0 - a / sdev;
	    arr[x] = (b * b * b * b) / c1;
	}
	/* outside the kernel */
	else
	    arr[x] = 0.0;

	sum += arr[x];
    }

    /* normalize */
    for (x = 0; x < n; x++)
	arr[x] /= sum;
}
