/******************************************************************
*              effects.c                                          *
*                                                                 *
* Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.*
*                                                                 *
*  This module contains code to do special effects.               *
*                                                                 *
* 080595 -HT- Flip Horiz works. Jeah.                             *
* 090595 -HT- Flip Vert, Rotate Right, Rotate Left and Negative   *
*             are working now.                                    *
* 160595 -HT- Makefile support.                                   *
******************************************************************/

#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"
 
Effect( nro )
unsigned char nro;
{
  int ew, eh, xx, yy;

  if( !Clip_Image.width )
    {
    printf("Effect what\n");
    return;
    }

  switch( nro )
    {
    case 0:  /* Flip Horiz */
      ew = Clip_Image.width;
      eh = Clip_Image.height;
      break;
    case 1:  /* Flip Vert */
      ew = Clip_Image.width;
      eh = Clip_Image.height;
      break;
    case 2:  /* Rotate Right */
      ew = Clip_Image.height;
      eh = Clip_Image.width;
      break;
    case 3:  /* Rotate Left */
      ew = Clip_Image.height;
      eh = Clip_Image.width;
      break;
    case 4:  /* Negative */
      ew = Clip_Image.width;
      eh = Clip_Image.height;
      break;
    }

  Make_Empty_Image( &Fake_Image, ew, eh );

  switch( nro )
    {
    case 0:
      for( yy=0; yy<Clip_Image.height; yy++ )
        for( xx=0; xx<Clip_Image.width; xx++ )
          Fake_Image.data.map_lines[yy][ew-1-xx]=Clip_Image.data.map_lines[yy][xx];
      break;
    case 1:
      for( yy=0; yy<Clip_Image.height; yy++ )
        for( xx=0; xx<Clip_Image.width; xx++ )
          Fake_Image.data.map_lines[eh-1-yy][xx]=Clip_Image.data.map_lines[yy][xx];
      break;
    case 2:
      for( yy=0; yy<Clip_Image.height; yy++ )
        for( xx=0; xx<Clip_Image.width; xx++ )
          Fake_Image.data.map_lines[xx][ew-1-yy]=Clip_Image.data.map_lines[yy][xx];
      break;
    case 3:
      for( yy=0; yy<Clip_Image.height; yy++ )
        for( xx=0; xx<Clip_Image.width; xx++ )
          Fake_Image.data.map_lines[eh-1-xx][yy]=Clip_Image.data.map_lines[yy][xx];
      break;
    case 4:
      for( yy=0; yy<Clip_Image.height; yy++ )
        for( xx=0; xx<Clip_Image.width; xx++ )
          Fake_Image.data.map_lines[yy][xx] =
            Clip_Image.Colour_Map_Size-Clip_Image.data.map_lines[yy][xx]-1;
      break;
    default:
      printf("Illegal effect number!\n");
      break;
    }

  for( yy=0; yy<Clip_Image.height; yy++ )
    free( Clip_Image.data.map_lines[yy] );
  free( Clip_Image.data.map_lines );
  free( Clip_Image.Colour_Map );

  MoveImageResponsibility( &Fake_Image, &Clip_Image );
}
