#import "aGroup-inter.h"
#import "aGroup.h"
#import "p4.h"

@implementation p4
- defaultConfig
{
  [self noAngleSetup];
}
- clip: (float) x : (float) y
{
  PSmoveto(x,y);
  PSrectclip(0,0,bounds.size.height,bounds.size.width);
  return self;
}
- resizeGenerator
{
  latticesize.height = 2.0 * bounds.size.height;
  latticesize.width = 2.0 * bounds.size.width;
  overx = latticesize.width;
  gravy = upy/2;
  gravx = (upx+overx)/2;
  return self;
}
- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  int i;
  
  pt.x = - point->x ;
  pt.y = - point->y ;

  imgrep = [srcimg bestRepresentation];
  for(i=0;i<4;i++){
    PSgsave(); // lower left
    PSrotate(90*i);
    [self clip:0.0:0.0];[imgrep drawAt: &pt];
    PSgrestore();
  }
  return self;
}
- (BOOL) isRigidLattice { return YES; }
@end
