#import "aGroup-inter.h"
#import "p1.h"

@implementation p1
- defaultConfig
{
  [self singleAngleSetup: 0.2];
  return self;
}

- generator: (NXCoord) x : (NXCoord) y 
{ 	
  [self clip: x : y];
  PSstroke();
  return self;
}

- resizeGenerator
{
  latticesize.height = frame.size.height;
  latticesize.width = frame.size.width;
  upx = [angle1slide floatValue] * latticesize.width;
  printf("Angleslider%f\n",[angle1slide floatValue]);
  upy = latticesize.height;
  overx = latticesize.width - abs(upx);
  gravy = upy/2;
  gravx = (upx+overx)/2;
  return self;
}

- clip: (NXCoord) x: (NXCoord) y 
{ 
  if(upx < 0.0)
    PSmoveto(x-upx,y);
  else 
    PSmoveto(x,y);
  PSrlineto(overx,0);
  PSrlineto(upx,upy);
  PSrlineto(-overx,0);
  PSclosepath();
  PSclip();
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  PSgsave();
  PStranslate(-gravx,-gravy);
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  return self;
}

- rightTranslatePoint: (NXPoint *) pt
{
  pt->x += overx;
  pt->y += 0;
  return self;
}
- leftTranslatePoint: (NXPoint *) pt
{
  pt->x -= overx;
  pt->y += 0;
  return self;
}

- isRigidLattice { return NO; }

- upTranslatePoint: (NXPoint *)pt
{
  pt->x += upx;
  pt->y += upy;
  return self;
}

- singleAngleSetup: (float) a
{
  [super singleAngleSetup: a];
  [angle1slide setMaxValue: 0.9];
  [angle1slide setMinValue: -0.9];
  [angle1slide setAction: @selector(anglesDidChange)];
  [angle1slide setTarget: self];
  return self;
}

@end
