/*
 *	ImageCompositor -- Randy Nelson
 *	An general class that composites an image at the current mouse location
 *
 *	You may freely copy, distribute and reuse the code in this example.
 *	NeXT disclaims any warranty of any kind, expressed or implied, as to
 *	its fitness for any particular use.
 */

#import "MouseTracker.h"

@interface ImageCompositor: MouseTracker
{
	id		brushDisplay;
	id		brushColor;
	id		brushSize;
	id		brushShape;
	id		infoPanel;
	id		helpPanel;
	NXColor		currentBrushColor;
	NXSize		currentBrushSize,
			windowMax,
			windowMin;
	NXPoint 	currentBrushCenter;
	int 		currentBrushShape;
	id 		brushImage,
			screenImage,
			undoImage;
}

- selfInit:sender;
- mouseDownAction:(NXPoint *)currentLocation;
- mouseDraggedAction:(NXPoint *)currentLocation;
- mouseUpAction:(NXPoint *)currentLocation;
- drawBrushImage:sender;
- erase:sender;
- undo:sender;
- helpPanel:sender;
- infoPanel:sender;
- colorPanel:sender;

@end
