/*+-----------------------------------------------------------------------+
 *| This file contains subroutines used to demonstrate how polygons may   |
 *| may be rendered by tesselation and smooth shading.                    |
 *|                                                                       |
 *| Author: Michael S. A. Robb         Version: 1.2        Date: 16/06/93 |
 *+-----------------------------------------------------------------------+
 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <time.h>

#include "24bit.h"

#define POLY_WIDTH  20
#define POLY_HEIGHT 20

#define POLY_NUMBER 1000

/*+-----------------------------------------------------------------------+
 *| This subroutine is used to time the speed of the rendering software.  |
 *+-----------------------------------------------------------------------+
 */

void polygon_demo1()
  {
  COORD vlist[3];
  int   n, m;
  long  start, finish;

  GRAPHICS_OPEN();

  polygon_setproc( render_triangle );      /* Call-back routine. */

  start = time( 0L );                      /* Starting time */

  for ( n = 0; n < POLY_NUMBER; n++ )      /* For all the polygons */
    {
    vlist[0].c_xpos = random(screen_width -(POLY_WIDTH  <<1) ) + POLY_WIDTH;
    vlist[0].c_ypos = random(screen_height-(POLY_HEIGHT <<1) ) + POLY_HEIGHT;

    vlist[1].c_xpos = vlist[0].c_xpos + random(POLY_WIDTH  <<1 ) - POLY_WIDTH;
    vlist[1].c_ypos = vlist[0].c_ypos + random(POLY_HEIGHT <<1) - POLY_HEIGHT;

    vlist[2].c_xpos = vlist[0].c_xpos + random(POLY_WIDTH  <<1 ) - POLY_WIDTH;
    vlist[2].c_ypos = vlist[0].c_ypos + random(POLY_HEIGHT <<1 ) - POLY_HEIGHT;

    for ( m = 0; m < 3; m++ )           /* For each vertex. */
      {
      vlist[m].c_zpos  = 0;
      vlist[m].c_red   = random( 256 ); /* Choose random colours */
      vlist[m].c_green = random( 256 );
      vlist[m].c_blue  = random( 256 );
      vlist[m].c_blend = 0;
      }

    polygon_tesselate( 3, vlist );
    }

  finish = time( 0L ) - start; /* Number of seconds that have elapsed. */

  GRAPHICS_CLOSE();

  printf( "For %d polygons, %lf seconds",     /* Display results */
          POLY_NUMBER,
          (double) POLY_NUMBER / finish );
  }

/*+-----------------------------------------------------------------------+
 *| This subroutine is used to generate a random polygon.                 |
 *+-----------------------------------------------------------------------+
 */

void polygon_random( num, vlist )
  int num;
  COORD *vlist;
  {
  int    n;
  double angle, radius, mult = M_PI * 2.0 / num;
  static int col = 0;

  randomize();

  col = ( ++col == 8 ? 1 : col );

  for ( n = 0; n < num; n++, vlist++ )
    {
    angle            = mult * n;
    radius           = random( 80 ) + 45;

    vlist -> c_xpos  = 256 + (long)( cos( angle ) * radius * 2 );
    vlist -> c_ypos  = 128 + (long)( sin( angle ) * radius );
    vlist -> c_zpos  = 0;

    vlist -> c_red   = random( 256 ) * (  col     & 0x01 );
    vlist -> c_green = random( 256 ) * ( (col>>1) & 0x01 );
    vlist -> c_blue  = random( 256 ) * ( (col>>2) & 0x01 );

    vlist -> c_blend = 0;
    }
  }

#define NUM_POINTS    16
#define POLY          polygon

void polygon_demo2( void )
  {
  COORD   polygon[NUM_POINTS];             /* Used for random polygons. */

  GRAPHICS_OPEN();

  polygon_setproc( render_triangle );      /* Call-back routine. */

  while ( !kbhit() )
    {
    polygon_random(    NUM_POINTS, POLY );

    polygon_tesselate( NUM_POINTS, POLY ); /* Render the polygon. */
    }

  GRAPHICS_CLOSE();
  }

/*+-----------------------------------------------------------------------+
 *| This is the first subroutine to be executed.                          |
 *+-----------------------------------------------------------------------+
 */

void main( void )
  {
  polygon_demo1();
  }
