#ifndef SoftWire_Optimizer_hpp
#define SoftWire_Optimizer_hpp

#include "RegisterAllocator.hpp"

namespace SoftWire
{
	class Optimizer : public RegisterAllocator
	{
	public:
		using RegisterAllocator::spillAll;

		// Optimization flags
		static void enableDropUnmodified();   // Default on
		static void disableDropUnmodified();

		static void enableSpillUnrelocated();   // Default off
		static void disableSpillUnrelocated();

	protected:
		struct AllocationTable
		{
			Allocation ERX[8];
			Allocation MM[8];
			Allocation XMM[8];
		};

		Optimizer();

		~Optimizer();

		const AllocationTable getAllocationState();
		void spillAll(const AllocationTable &state);   // Restore state to minimize spills

		// Register state restore for forward and backward jumps
		void restoreForward(const AllocationTable &state);
		void restoreBackward(const AllocationTable &state);

	protected:
		// Overloaded to detect modified/unmodified registers
		virtual Encoding *x86(int instructionID,
		                      const Operand &firstOperand = Operand::OPERAND_VOID,
		                      const Operand &secondOperand = Operand::OPERAND_VOID,
		                      const Operand &thirdOperand = Operand::OPERAND_VOID);

	private:
		static bool dropUnmodified;
		static bool spillUnrelocated;
	};
}

#endif   // SoftWire_Optimizer_hpp