/**
 ** sipp - SImple Polygon Processor
 **
 **  A general 3d graphic package
 **
 **  Copyright Jonas Yngvesson  (jonas-y@isy.liu.se) 1988/89/90/91
 **            Inge Wallin      (ingwa@isy.liu.se)         1990/91
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** mask.c - Mask shader: use a masking function to select between 
 **          two shaders.
 **/

#include <sipp.h>
#include <shaders.h>

void
mask_shader(a, b, c, u, v, w, view_vec, lights, sd, color)
    double  a, b, c, u, v, w;
    Vector  view_vec;
    Lightsource *lights;
    Mask_desc *sd;
    Color *color;
{
    int  ras_x, ras_y;
    bool mapped;

    ras_x = u * sd->xscale + sd->x0;
    ras_y = v * sd->yscale + sd->y0;
    mapped = ((ras_x >=0 && ras_x < sd->xsize) 
              && (ras_y >= 0 && ras_y < sd->ysize)
              && sd->pixel_test(sd->mask, ras_x, ras_y));
    if (mapped) {
        sd->fg_shader(a, b, c, u, v, w, view_vec, lights, sd->fg_surface,
                      color); 
    } else {
        sd->bg_shader(a, b, c, u, v, w, view_vec, lights, sd->bg_surface,
                      color); 
    }
}
