#include <sipp.h>


struct {
    int vertex[4];
} sides[] = {
    {0, 3, 2, 1}, 
    {0, 1, 5, 4}, 
    {1, 2, 6, 5}, 
    {2, 3, 7, 6}, 
    {3, 0, 4, 7}, 
    {4, 5, 6, 7}
};


Object *
sipp_block(xsize, ysize, zsize, surface, shader)
    double  xsize;
    double  ysize;
    double  zsize;
    void   *surface;
    Shader *shader;
{
    Object  *block;
    Vector  vertices[8];
    int     i, j;
    
    vertices[0].x = -xsize / 2.0;
    vertices[0].y = -ysize / 2.0;
    vertices[0].z = -zsize / 2.0;
    vertices[1].x = xsize / 2.0;
    vertices[1].y = -ysize / 2.0;
    vertices[1].z = -zsize / 2.0;
    vertices[2].x = xsize / 2.0;
    vertices[2].y = ysize / 2.0;
    vertices[2].z = -zsize / 2.0;
    vertices[3].x = -xsize / 2.0;
    vertices[3].y = ysize / 2.0;
    vertices[3].z = -zsize / 2.0;
    vertices[4].x = -xsize / 2.0;
    vertices[4].y = -ysize / 2.0;
    vertices[4].z = zsize / 2.0;
    vertices[5].x = xsize / 2.0;
    vertices[5].y = -ysize / 2.0;
    vertices[5].z = zsize / 2.0;
    vertices[6].x = xsize / 2.0;
    vertices[6].y = ysize / 2.0;
    vertices[6].z = zsize / 2.0;
    vertices[7].x = -xsize / 2.0;
    vertices[7].y = ysize / 2.0;
    vertices[7].z = zsize / 2.0;

    block = object_create();

    for (i = 0; i < 6; i++) {
        for (j = 0; j < 4; j++) {
            vertex_tx_push(vertices[sides[i].vertex[j]].x, 
                           vertices[sides[i].vertex[j]].y, 
                           vertices[sides[i].vertex[j]].z, 
                           vertices[sides[i].vertex[j]].x, 
                           vertices[sides[i].vertex[j]].y, 
                           vertices[sides[i].vertex[j]].z);
        }
        polygon_push();
        object_add_surface(block, surface_create(surface, shader));
    }

    return block;    
}


Object *
sipp_cube(size, surface, shader)
    double   size;
    void     *surface;
    Shader   *shader;
{
    return sipp_block(size, size, size, surface, shader);
}

