/* rleclient.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <math.h>
#include <rle.h>
#include "scry.h"


/* main:  transmit RLE file to PC, Xview, or Sunview server 
   parse_args:  parse command-line arguments  */


int corner_arg_made = 0 ;

main (argc, argv)

int argc;
char *argv[];

{
    rle_hdr the_hdr ;			/* RLE header */
    unsigned char *rle_scanline ;
    unsigned char *rle_rows[3] ;
    unsigned char *rle_ptr ;

    char *which_server;			/* symbolic name of server */
    int	prognum;			/* RPC program number */
    int comp_option;			/* compression option */
    int rec_option;			/* recording option */
    int	flip_vertical = 0;		/* don't flip */
    char *savename = NULL ;		/* name to save Anima file under */
	/* upper left point of image is at (corner_left, corner_top) */
    int corner_left = 0;
    int corner_top = 0;
    unsigned char *rle_image;		/* RLE image buffer */
    int height, width, depth ;
    int i, j ;

	/* initialize options to default values */
    which_server = NULL;
    rec_option = S_PREVIEW;		/* preview mode */
    comp_option = S_NONE;
    prognum = S_PCPROG;		/* PC server RPC program number */

	/* parse command-line arguments */
    parse_args (argc, argv, &corner_left, &corner_top, &which_server, &comp_option, 
	&rec_option, &prognum, &flip_vertical, &savename) ;

	/* read from stdin */
    the_hdr.rle_file = stdin ;
	/* get RLE header */
    if ((rle_get_setup(&the_hdr)) != RLE_SUCCESS)
        exit(0) ;
    if ((rle_image = (unsigned char *) malloc(the_hdr.xmax*the_hdr.ymax*3)) == NULL)
    {
        fprintf (stderr,"unable to allocate space for RLE image\n") ;
        exit(0) ;
    }
    rle_scanline = (unsigned char *) malloc(the_hdr.xmax*3) ; 
    rle_ptr = rle_image ;
    for (i = 0 ; i < 3 ; i++)
        rle_rows[i] = &rle_scanline[i*the_hdr.xmax] ;
	    /* for all rows */
    for (i = 0 ; i < the_hdr.ymax  ; i++)
    {
        rle_getrow (&the_hdr,rle_rows) ;
        for (j = 0 ; j < the_hdr.xmax ; j++)
        {
            *rle_ptr++ = rle_scanline[j] ;
            *rle_ptr++ = rle_scanline[j+the_hdr.xmax] ;
            *rle_ptr++ = rle_scanline[j+2*the_hdr.xmax] ;
        }
    }
    height = the_hdr.ymax ;
    width = the_hdr.xmax ;
    depth = 3 ;

    if (flip_vertical)
	scry_v_flip(rle_image,height,width,depth) ;
	    
	/* only has effect if server maximum display size is
	   less than image */
    if (corner_arg_made) 
	    /* if not called, center of image will be sent if
	       bigger than display */
        scry_set_corner(corner_left,corner_top) ;
	/* if to connect to server */
    if (which_server != NULL)
    {
	if (prognum == 0)
	{
	    fprintf (stderr,"program number must be supplied\n") ;
	    exit(0) ;
	}
	    /* connect to server */
        if (!scry_connect (which_server, prognum))
            exit(0) ;
		/* initialize recorder if present */
        scry_init_record (rec_option,1) ;
    }
	/* if saving Anima file */
    if (savename != NULL)
        scry_set_filename(savename,1) ;
    fprintf (stderr,"RLE image height, width = %d %d\n",height,width) ;
    if (which_server != NULL)
	    /* transmit Anima file */
        scry_send_image(rle_image,comp_option,height,width,depth) ;
    else if (savename != NULL)
	    /* save Anima file */
        scry_save_anima(rle_image,height,width,depth) ;
    else
        fprintf (stderr,"No server or file name chosen: no action taken\n") ;
	/* close client */
    scry_close();

	/* free memory previously allocated */
    free (rle_image);
}




/* get command-line arguments */

parse_args (argc,argv,start_col,start_row,which_server,comp,
	    record,prognum,flip_vertical,savename)

int argc;
char *argv[];
int *start_row, *start_col ;	/* upper left hand corner */
char **which_server;		/* symbolic name of server */
int *comp;			/* compression option */
int *record;			/* recording option */
int *prognum;			/* RPC program number */
int *flip_vertical;		/* flip or not */
char **savename ;		/* Anima file name */

{
    int i;	/* command line word count */
    int j;
    char *temp_string;

    for (i = 1; i < argc; i++)
    {
	if (*argv[i] != '-')
	{
	    fprintf (stderr, "All arguments must start with a -\n") ;
	    fprintf (stderr, "Invoke with %s -h for help\n", argv[0]) ;
	    exit (0) ;
	}
	switch(*(argv[i]+1))
	{
		/* name to save Anima file under */
	    case 'o':
		*savename = argv[++i] ;
		break ;
	    case 'v':	/* flip image vertically */
		*flip_vertical = 1;
		break;
	    case 's':	/* upper left hand corner */
		*start_col = atoi(argv[++i]);
		*start_row = atoi(argv[++i]);
		corner_arg_made = 1 ;
		break;
	    case 'r':	/* recording option */
		*record = atoi(argv[++i]);
		break ;
            case 'w':	/* server name */
                *which_server = argv[++i];
                break;
            case 'p':	/* RPC program number */
                *prognum = atoi(argv[++i]);
                break;
            case 'c':	/* compression option */
                *comp = 0;
                temp_string = argv[++i];
                for(j = 0; j < strlen(temp_string); j++)
		{
                    switch(temp_string[j])
		    {
			case 'c':
			    *comp |= S_CCC; break;
			case 'q':
			    *comp |= S_QUANTIZE; break;
			case 'l':
			    *comp |= S_LEMPEL_ZIV; break;
			case 'n':
			    *comp = S_NONE; break;
                    }
                }
                break;
	    case 'h':
	    case 'H':
	    case '?':
	      puts("rleclient:  transfers RLE image to PC, Sunview, or X server");
	      puts("Invoke:  rleclient -w server -p prognum [args] < input\n");
	      puts("-w hostname    connect to server hostname");
	      puts("            this argument must be supplied unless");
	      puts("            saving an Anima file locally");
	      puts("-p prognum     RPC program number");
	      puts("            default is the PC server RPC program number");
	      puts("-c compr       one of c, q, cl, ql, or n");
	      puts("            default is n (none)");
	      puts("-r frame_#     set record on");
	      puts("            default is preview mode");
	      puts("-v             flip image vertically "); 
	      puts("            default is not to flip");
	      puts("-o filename    save under anima file") ;
	      puts("            default is not to save");
	      puts("-s x y         upper left hand corner");
	      puts("            default is (0,0)");
              puts("-h, -H, -?      this message") ;
		exit (-1) ;
	    default:
		return (-1);
		break;
	}
    }
}
