/* targam8.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* TARGA M8 routines */

/* init_display:  initializes TARGA M8 board
   clear_display:  clears frame buffer */

#include        <memory.h>
#include        <stdio.h>
#include	"image.h"
#include        <tardev.h>    /* TARGA include file - large memory model */


#define         OVERLAY 0               /* overlay mode off        */ 

extern struct TARStruct *targa;

#define SCANSIZE 512		/* maximum row length */


/* initializes TARGA M8 board */

int
init_display ()

{

    if (GraphInit (TYPE_M8) == -1)
    {
        perror("GraphInit failed - check I/O space configuration.\n");
        return (0);
    }

    PutM8BWall(0,0) ;
    SetM8InMap(0) ;
    SetM8OutMap(0) ;
    GetScrSize(&(image_info.width),&(image_info.height)) ;
    ++image_info.width ;
    ++image_info.height ;
    clear_display(0,0,0) ;
    image_info.depth = 1 ;
    return (1) ;
}


/* clears display to grey-scale value generated from R, G, B input,
   which must be in the range (0,255) */

clear_display(r,g,b)

int r, g, b;

{
    unsigned char one[SCANSIZE] ;         /* one scan line */
    unsigned char *oneptr ;
    unsigned short i ;
    unsigned char grey ;

    /* idea borrowed from Paul Raveling IMG package */
    grey = (unsigned char) ((77*r + 150*g + 29*b) >> 8) ;
    oneptr = one ;
        /* set one scan line to color */
    for(i = 0; i < image_info.width ; i++)
        *oneptr++ = grey ;
            /* for all scan lines */
    for(i = 0; i < image_info.height ; i++)
        PutRow (one,0,image_info.width -1,i,-1);
}
