/* graph32.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <memory.h>
#include "scrysrv.h"
#include "image.h"


/* 32-bit frame buffer-dependent routines */

/* xdr_map:  XDR decodes incoming RGB color map
   xdr_ccc_decompress:  decompresses and displays CCC and
	     run length encoded image
   xdr_qdata:  expands 8-bit incoming image to 32-bit format
	     and displays it
   xdr_udata:  expands 24-bit incoming image to 32-bit format
	     and displays it    */

#define		SIZBLOC		4 	/* pixels in block side */
#define		DEPTH		4	/* color resolution in bytes */
#define		MAXSCAN		604	/* maximum number of pixels in row */
#define		MAX_TO_READ	32764   /* 32K - (32K % SIZBLOC) */

unsigned char part [SIZBLOC * DEPTH * MAXSCAN] ;	/* decompressed scan lines */


/* XDR decodes incoming RGB color map */

bool_t 
xdr_map (xdrsp,map)

XDR *xdrsp ;		/* XDR handle */
struct mapstore *map ;	/* color map */

{
    int i ;

	/* number of entries in color map */
    if (!xdr_long(xdrsp,&(map->num)))
        return (0) ;
#ifdef DEBUG
    printf ("map entries = %d\n",map->num) ;
#endif
    memset(map->s_map,'\0',256*3) ; 
    if (!xdr_opaque(xdrsp,map->s_map,map->num*3))
        return (0) ;
    return(1) ;
}




/* decompresses and displays CCC and run length encoded image */

bool_t
xdr_ccc_decompress (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    int client_width ;		/* incoming image width */
    int block_width_num ;	/* number of blocks per 4 rows of image */
    int total_blocks ;		/* total 4x4 blocks in image */
    long current_block ;
    int run_ctr ;
    int row ;			/* row in 32 bit frame buffer */
    int decal ;			/* skips to new row */
    register unsigned char *ptin ;	/* incoming buffer pointer */
    unsigned char ind0, ind1 ;	/* indices to colors inside the block */
    register unsigned char red0, green0, blue0 ;
    register unsigned char red1, green1, blue1 ;
    register unsigned char *ptbloc ;	/* pointer to beginning of block */
    long total_read ;		/* total bytes in compressed image */
    long total_to_read ;	/* total left to read */
    int bytes_processed ;	/* total bytes read in current chunk */
    register int j, k ;

    client_width = (int) image_info->client_wd ;
    block_width_num = client_width / SIZBLOC ;
    decal = (image_info->width + SIZBLOC) * DEPTH ;
    total_blocks = block_width_num*((int)(image_info->client_ht)/SIZBLOC) ;
    row = 0 ;
    for (k = 0 ; k < image_info->width * SIZBLOC * DEPTH ; k += DEPTH)
    {
        part[k] = back_blue ;
        part[k+1] = back_green ;
        part[k+2] = back_red ;
        part[k+3] = 0 ;
    }
#ifdef DEBUG
    printf ("ccc: left %d bottom %d top %d\n",center_x_left,center_y_bottom,center_y_top) ;
#endif
        /* if necessary, fill in bottom border with color */
    for (k = 0 ; k < center_y_bottom ; k++)
    {
        PutRow (part,0,image_info->width-1,k,-1);
        ++row ;
    }
    total_to_read = image_info->total ;
    current_block = 0 ;
    run_ctr = 1 ;
    while (total_to_read > 0)
    {
        if (total_to_read >= MAX_TO_READ)
        {
            total_read = MAX_TO_READ ;
            total_to_read -= MAX_TO_READ ;
        }
        else
        {
            total_read = total_to_read ;
            total_to_read = 0 ;
        }
        bytes_processed = 0 ;
	    /* if data not already read */
        if (!(image_info->compression & LEMPEL_ZIV))
        {
            if (!xdr_opaque(xdrsp,image_info->data,total_read))
            {
                fprintf (stderr,"xdr_opaque died with CCC\n") ;
                if (image_info->data == NULL)
                    fprintf (stderr,"data = NULL\n") ;
                return(0) ;
            }
        }
        ptin = image_info->data ;
    
	    /* for all 4x4 BTC blocks */
        while ((current_block < total_blocks) && (bytes_processed < MAX_TO_READ))
        {
            if ((current_block % block_width_num) == 0)
            {
                if (current_block != 0)
                {
                    PutRow (part,0,image_info->width-1,row+3,-1);
                    PutRow (part+image_info->width*DEPTH,0,image_info->width-1,
			    row+2,-1);
                    PutRow (part+image_info->width*2*DEPTH,0,image_info->width-1,
			    row+1,-1);
                    PutRow (part+image_info->width*3*DEPTH,0,image_info->width-1,
			    row,-1);
                    row += SIZBLOC ;
                }
                ptbloc = &(part[(3*image_info->width+center_x_left)*DEPTH]) ;
            }
            ind0 = *ptin++ ;
            ind1 = *ptin++ ;
            red0 = map.s_map [ind0 ][RED] ;
            green0 = map.s_map [ind0 ][GREEN] ;
            blue0 = map.s_map [ind0 ][BLUE] ;
            red1 = map.s_map [ind1 ][RED] ;
            green1 = map.s_map [ind1 ][GREEN] ;
            blue1 = map.s_map [ind1 ][BLUE] ;
		/* if 2 colors in 4x4 block */
            if ( ind0 != ind1 )
            {
		register unsigned char *ptc ;
		register unsigned short bitmap ;	/* BTC bitmap */

		run_ctr = 1 ;
                bitmap = *ptin++ ;
                bitmap = (bitmap << 8) | *ptin ;
	        ++ptin ;
                    /* scan the bit map and assign the colors */
                ptc = ptbloc ;
		if ( bitmap & 01)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 02)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 04)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 010)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
                ptc -= decal ;
		if ( bitmap & 020)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 040)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 0100)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 0200)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
                ptc -= decal ;
		if ( bitmap & 0400)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 01000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 02000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
                *ptc++ = 0 ;
		if ( bitmap & 04000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
		*ptc++ = 0 ;
                ptc -= decal ;
		if ( bitmap & 010000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
		*ptc++ = 0 ;
		if ( bitmap & 020000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
		*ptc++ = 0 ;
		if ( bitmap & 040000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
		*ptc++ = 0 ;
		if ( bitmap & 0100000)
		{
		    *ptc++ = blue1 ;
		    *ptc++ = green1 ;
		    *ptc++ = red1 ;
		}
		else
		{
		    *ptc++ = blue0 ;
		    *ptc++ = green0 ;
		    *ptc++ = red0 ;
		}
		*ptc++ = 0 ;
            }
            else			/* expand run-length */
            {
		unsigned char bloc[SIZBLOC * DEPTH] ;
                register unsigned char *ptc ;

                run_ctr = *ptin++ ;
                run_ctr = (run_ctr << 8) | *ptin ;
                ptin++ ;
		if (run_ctr > block_width_num)
                {
		    fprintf (stderr,"bad run length\n") ;
                    exit(0) ;
                }
		ptc = bloc ;
		for (k = 0 ; k < SIZBLOC ; k++)
                {
                    *ptc++ = blue0 ;
                    *ptc++ = green0 ;
                    *ptc++ = red0 ;
                    *ptc++ = 0 ;
                }
		ptc = ptbloc ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC*DEPTH)
		    memcpy(ptc,bloc,SIZBLOC*DEPTH) ;
		ptc = ptbloc - image_info->width * DEPTH ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC*DEPTH)
		    memcpy(ptc,bloc,SIZBLOC*DEPTH) ;
		ptc = ptbloc - image_info->width * 2 * DEPTH ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC*DEPTH)
		    memcpy(ptc,bloc,SIZBLOC*DEPTH) ;
		ptc = ptbloc - image_info->width * 3 * DEPTH ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC*DEPTH)
		    memcpy(ptc,bloc,SIZBLOC*DEPTH) ;
            }
            bytes_processed += 4 ;
            current_block += run_ctr ;
            ptbloc += (DEPTH * SIZBLOC*run_ctr) ;
        }
    }			/* end for a group of lines */
	/* display last 4 scan lines */
    PutRow (part,0,image_info->width-1,row+3,-1);
    PutRow (part+image_info->width*DEPTH,0,image_info->width-1,
	    row+2,-1);
    PutRow (part+image_info->width*2*DEPTH,0,image_info->width-1,
	    row+1,-1);
    PutRow (part+image_info->width*3*DEPTH,0,image_info->width-1,
	    row,-1);
    for (k = 0 ; k < image_info->width * SIZBLOC * DEPTH ; k += DEPTH)
    {
        part[k] = back_blue ;
        part[k+1] = back_green ;
        part[k+2] = back_red ;
        part[k+3] = 0 ;
    }
	/* fill in top border if necessary */
    for (k = center_y_top ; k < image_info->height ; k++)
        PutRow (part,0,image_info->width-1,k,-1);
    return (1) ;
}




/* expands 24-bit incoming image to 32-bit format and
   displays it */

bool_t 
xdr_udata (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    int i, j, k ;
    unsigned char *ptc ;
    unsigned char part [4 * 4 * MAXSCAN] ;
    unsigned char *packptr ;

    for (i = 0 ; i < image_info->width * 4 ; i += 4)
    {
        part[i] = back_blue ;
        part[i+1] = back_green ;
        part[i+2] = back_red ;
        part[i+3] = 0 ;
    }
#ifdef DEBUG
    printf ("NONE: left %d bottom %d top %d\n",center_x_left,center_y_bottom,center_y_top) ;
    printf ("swidth = %d, sheight = %d, cwidth = %ld\n",image_info->width,
            image_info->height,image_info->client_wd) ;
#endif
        /* fill in bottom border if necessary */
    for (i = 0 ; i < center_y_bottom ; i++)
        PutRow(part,0,image_info->width-1,i,-1) ;
    ptc = part + center_x_left * 4 ;
    packptr = image_info->data ;
	/* get and display image */
    for (i = center_y_bottom ; i < center_y_top ; i++)
    {
        if (!xdr_opaque(xdrsp,image_info->data,image_info->client_wd*3))
            return (0) ;
        
        for (k = 0 ; k < image_info->client_wd ; k++)
        {
            *(ptc+2) = *packptr++ ;
            *(ptc+1) = *packptr++ ;
            *ptc = *packptr++ ;
            *(ptc+3) = 0 ;
            ptc += 4 ;
        }
        PutRow(part,0,image_info->width-1,i,-1) ;
        ptc = part + center_x_left * 4 ;
        packptr = image_info->data ;
    }
    for (i = 0 ; i < image_info->width * 4 ; i += 4)
    {
        part[i] = back_blue ;
        part[i+1] = back_green ;
        part[i+2] = back_red ;
        part[i+3] = 0 ;
    }
	/* fill in top border if necessary */
    for (i = center_y_top ; i < image_info->height ; i++)
        PutRow(part,0,image_info->width-1,i,-1) ;
    return(1) ;
}




/* expands 8-bit incoming image to 32-bit format and
   displays it */

bool_t 
xdr_qdata (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    int i, j, k ;
    unsigned char *ptc ;
    unsigned char part [4 * 4 * MAXSCAN] ;
    unsigned char *packptr ;

#ifdef DEBUG
    printf ("QUANTIZE: left %d bottom %d top %d\n",center_x_left,center_y_bottom,center_y_top) ;
#endif
    for (i = 0 ; i < image_info->width * 4 ; i += 4)
    {
        part[i] = back_blue ;
        part[i+1] = back_green ;
        part[i+2] = back_red ;
        part[i+3] = 0 ;
    }
       /* fill in bottom border if necessary */
    for (i = 0 ; i < center_y_bottom ; i++)
        PutRow(part,0,image_info->width-1,i,-1) ;
    ptc = part + center_x_left * 4 ;
    packptr = image_info->data ;
	/* get and display image */
    for (i = center_y_bottom ; i < center_y_top ; i++)
    {
        if (!xdr_opaque(xdrsp,image_info->data,image_info->client_wd))
            return (0) ;
        for (k = 0 ; k < image_info->client_wd ; k++)
        {
            *(ptc+2) = map.s_map[*packptr][RED] ;
            *(ptc+1) = map.s_map[*packptr][GREEN] ;
            *ptc = map.s_map[*packptr++][BLUE] ;
            *(ptc+3) = 0 ;
            ptc += 4 ;
        }
        PutRow(part,0,image_info->width-1,i,-1) ;
        ptc = part + center_x_left * 4 ;
        packptr = image_info->data ;
    }
    for (i = 0 ; i < image_info->width * 4 ; i += 4)
    {
        part[i] = back_blue ;
        part[i+1] = back_green ;
        part[i+2] = back_red ;
        part[i+3] = 0 ;
    }
	/* fill in top border if necessary */
    for (i = center_y_top ; i < image_info->height ; i++)
        PutRow(part,0,image_info->width-1,i,-1) ;
    return(1) ;
}
