.TH SVSERV n "January 28 1991"
.SH NAME
svserv - Sunview-based remote procedure call server
.SH SYNOPSIS
.B svserv
.B \-p 
prog_num
[
.B \-w
winx winy
]
.SH DESCRIPTION 
.PP
Serves incoming remote procedure calls (RPCs) to display images sent
from a Scry client in a Sunview window.
This graphics window is created separately from
the text window in which the server is invoked.  The image data can be
written to a disk file for later use by the \f3svanima\f1 movie preview program.
.PP
After \f3svserv\f1 is invoked, two windows will appear on the screen,
one a control panel, and the other the window in which images will
appear.  Pushing the "quit" button causes the windows to be destroyed
and \f3svserv\f1 to exit.  Entering a number in the "gamma" field will
adjust the gamma value of the next image received.  The default
gamma value is 1, and the legal range is from 0.1 to 4.
The default gamma value can be changed by resetting \f3S_DEF_GAMMA_VALUE\f1
in \f2scry/include/scry_limits.h\f1 before making Scry.
.PP
The RPC server calls \f3graphics_dispatch\f1
(located in \f2svserv\f1.c)
based on information in the header of the incoming RPC call.  Cases in
\f3graphics_dispatch\f1
correspond to supported client procedures.  Routines starting with xdr_
decode incoming network information into the server format.
The type of compression is set by the client, and communicated to the server
as part of the first RPC.
.PP
See \f3svanima(n)\f1 for information on using color with Sunview
and on defaults for window size, etc.
.SH OPTIONS
.TP
.B \-p 
set the program number to be used.  The use of different program numbers
allows several servers to be active on a particular workstation simultaneously.
Each corresponding client must be invoked with the identical program
number (see \f3scry_libclient\f1(n)).
.TP
.B \-w
set the coordinates of the upper left corner of the window on the screen.
.SH DEFAULTS
The defaults to the command line arguments are as follows:
.sp
1) The program number is 
.B 4000\.
.sp
2) The upper left corner is at (0,0).
.sp
.SH FILES
.TP
The Scry Sunview server is located in \f2scry/svserv\f1
.TP
.I Makefile
makes the executable of the server
.TP
.I svwin.h
header file for Sunview dependent variables
.TP
.I svserv.c
RPC server
.TP
.I svdisplay.c
sets up image information and displays the images in the
Sunview window as they come in
.SH SEE ALSO
\f3scry_client(n), scry_libclient(n), svanima(n)\f1
.SH AUTHORS
David Robertson, Teck-Joo Chua, Max Rible, and Antony Courtney
