.TH SCRY_CLIENT n "January 28 1991"
.SH NAME
Scry_client - Scry client overview
.SH DESCRIPTION
.PP
The Scry client compresses and transmits images to the Scry servers.
The client library and test programs run on several different
systems that provide the 4BSD Unix socket IPC
mechanisms, and enough of the Unix run-time
library to support the Sun RPC library, RPC's being the
preferred communication mechanism.  Programs using the client
library have been tested on 4.3BSD Unix systems and Cray UNICOS.
.PP
The tasks of the client are the compression
and transmission of the image to the server, and are handled
by the routines described in \f3scry_libclient\f1(n).
Rather than choose one among many image header formats,
this layer deals in raw (headerless) images.
It is up to the user to read in the particular image format
and extract the raw image, and the color map if the image is
8-bit.
.PP
Since the \f3libclient\f1 module does not know
the characteristics of the image that it is dealing with,
it is not possible to automatically select an optimal
compression technique.
Scry provides several compression techniques, some lossy,
some lossless, some suitable for synthetic images (those
generated by scan converting the graphics primitives generated
by most visualization algorithms) and some suitable for
natural (remote sensed) images.  The compression techniques used are:
(1) the CCC algorithm combined with run-length encoding [1, 2],
(2) a modified version of Paul Raveling's IMG 1.3 color quantization
code (availability of the original code is given in the \f2README\f1
in this directory),
and (3) Lempel-Ziv coding [3].
A detailed analysis of the characteristics of all of
the useful combinations of these is too tedious here (see
[4]), but a few rules of thumb are useful.
If the final display is to be a video movie, fairly
inexact compression works well.  For video movies made from images
generated by rendering graphics primitives, we usually use the CCC
algorithm, with Lempel-Ziv cascaded
if the images are being sent via a wide-area network.  For
natural images, the IMG 1.3 quantization algorithm, and
Lempel-Ziv compression are frequently useful.
.PP
Before compression is performed, the image depth is converted to
that of the server display if the latter's is smaller, and if the image
is larger than the
display, it is truncated to the display's size.  This saves time
in compression and transmission.
It is also possible to store compressed images as Anima files on
the client, without this truncation in size.
.PP
The final step is to send the compressed image to the server.
The RPC-based server is identified by internet
address and RPC program number.  In some cases the program
number has a default value, and in some cases it must be supplied.  In
particular, it must be supplied when there is the possibility
of running more than one server as can be done on, for instance,
a Sun workstation.
See the sample program directory \f2scry/samples\f1, and \f3Xserv\f1(3),
for programs that operate at this level.
.SH AUTHORS
David Robertson, Nicole Texier, James Huang, and Bill Johnston
.SH "SEE ALSO"
\f3scry_libclient\f1(n), \f3pcserv\f1(n), \f3Xserv\f1(n)
.sp
[1]  G. Campbell, T. DeFanti, J. Frederiksen, S.  Joyce,  L.
Leske,  J.  Lindberg and D. Sandin, ``Two Bit/Pixel Full
Color Encoding,'' Computer Graphics,  vol.  20,  no.  4,
1986.  (Proceedings ACM SIGGRAPH, 1986)
.sp
[2]  TAAC-1 Application Accelerator:  2.3 Release Notes,
Part No:  800-1896-12, Revision A of 15 April 1989, Sun
Microsystems, Inc., 2550 Garcia Avenue, Mountain View, CA  94043.
.sp
[3]  T.  Welch,  ``A  Technique  for  High  Performance  Data
Compression,''  IEEE  Computer,  vol.  17,  no. 6, June,
1984.
.sp
[4]  N. Texier, W. Johnston, D.  Robertson,  ``Encoding  Synthetic
Animated Images,'' LBL-24236, University of California,
Lawrence  Berkeley  Laboratory,  Berkeley,  CA,
1987.
