.TH MOVIE n "January 28 1991"
.SH NAME
movie \- reads script to control playback of frames on a Panasonic
TQ-2026F videodisk or Sony LVR-5000 videodisk.
.SH SYNOPSIS
.nf
.LP
.B movie scriptfile
.fi
.SH DESCRIPTION
\f2movie\f1 reads the file \f2scriptfile\f1 and interprets
lines in it as commands to control the playback of frames on
the Sony or Panasonic videodisk.  It can be used to put together a movie
to be dubbed onto VHS format videotape.
.LP
Valid commands in \f2scriptfile\f1 are as follows:
.LP
\f2search\f1 "framenum" searches to the given frame number.
Valid "framenum"'s range from 1 to 43500 for the Sony,
and 1 to 24000 for the Panasonic.
.LP
\f2blank\f1 searches to a frame that had black recorded on it,
i.e. it blanks the screen.  It is highly recommended that
any time \f2search\f1 is performed, \f2blank\f1 is called
first to avoid noise in the image during the search.
.LP
\f2playto\f1 "framenum slow videorate" plays frames sequentially from the
current frame up to frame number "framenum".  The current frame
is either the result of \f2search\f1 or the last frame of a
preceding \f2playto\f1.
The value of "framenum" may be less than the frame number of the current
frame.  In this case, frames are played back in descending (rather than
ascending) order.
Currently the only legal second argument is "slow."
"videorate" determines the rate of playback.
Frames on videodisk are displayed at 30 frames/second
divided by "videorate".  If the value of "videorate" is 2, for example,
the resulting rate is 15 frames per second.
A "videorate" of 3 results in 10 frames per second; a "videorate" of
5 indicates 6 frames per second, and so on.
.LP
\f2hold\f1 "seconds" leaves the current frame on the screen for "seconds" 
length of time.
.LP
As \f2movie\f1 is executing any comments (a line starting with "#")
are printed out as they are arrived at, and when "playto" is encountered
the frames to be displayed and the rate of display are printed out.
.LP
The following is a sample script file:
.sp
.nf
.na
blank
hold 2
# Larry June's movie - February 27, 1989
search 5852
hold 4
playto 6400 slow 2
hold 3
blank
hold 2
.fi
.ad
.sp
.SH "SEE ALSO"
.B pcserv(n)
.SH AUTHOR
David Robertson


