/* anima_to_ras.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* converts Anima frame to Sun rasterfile */

#include <stdio.h> 
#include <math.h> 
#include <scry_image.h>
#include <scry_anima.h>
#include <rasterfile.h>
#include <string.h>

int true_height ;
int true_width ;

void
anima_to_sunrast()

{
    FILE *rastfile ;		/* Sun rasterfile */
    char rastname[80] ;
    char tmp_name[80] ;
    int i , j;
    unsigned char red[256], green[256], blue[256];
    int header[8] ;		/* Sun rasterfile header */
    int xform_indices[256] ;	/* for compatibility with other utilities only */
    
    if (S_anima_file == NULL)
    {
	fprintf (stderr,"anima file has not been input\n") ;
	return ;
    }
    strncpy(tmp_name,S_anima_filename,strlen(S_anima_filename)-4) ;
    tmp_name[strlen(S_anima_filename)-4] = '\0' ;
    sprintf (rastname,"%s.%d.rf",tmp_name,S_avars.current) ;
    if ((rastfile = fopen(rastname,"w")) == NULL)
    {
	perror("opening Sun rasterfile\n") ;
	return ;
    }

        /* if zoomed, find true dimensions */
    if (!S_do_zoom)
    {
        true_height = S_image_info.s_height;
        true_width = S_image_info.s_width;
    }
    else
    {
        true_height = S_image_info.s_height / 2;
        true_width = S_image_info.s_width / 2;
    }
    for(i = 0; i < S_mapnum; i++)
    {
        red[i] = S_map[i][S_RED] ;
        green[i] = S_map[i][S_GREEN] ;
        blue[i] = S_map[i][S_BLUE] ;
    }
	/* for compatibility only */
    for (i = 0 ; i < 256 ; i++)
	xform_indices[i] = i ;

        /* decompress image */
    decompress_ccc(S_image_info.data, S_image_mem, true_height, true_width,xform_indices);
    
	/* fill in Sun rasterfile header */
    header[0] = RAS_MAGIC ;
    header[1] = true_width ;
    header[2] = true_height ;
    header[3] = 8 ;
    header[4] = true_width * true_height ;
    header[5] = RT_STANDARD ;
    header[6] = RMT_EQUAL_RGB ;
    header[7] = S_mapnum * 3 ;
    for (i = 0 ; i < 8 ; i++)
	header[i] = htonl(header[i]) ;
	    /* write out Sun rasterfile */
    fwrite(header,8,sizeof(int),rastfile) ;
    fwrite(red,S_mapnum,1,rastfile) ;
    fwrite(green,S_mapnum,1,rastfile) ;
    fwrite(blue,S_mapnum,1,rastfile) ;
    fwrite(S_image_mem,true_width*true_height,1,rastfile) ;
    fclose(rastfile) ;
}
