/* genonemap.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>


/* generates one color map for an Anima file in "many map" format,
   i.e. a potentially different color map in the header for
   each frame */

/* parse_args:  parse command_line arguments
   init_vars:  miscellaneous initialization */


static void parse_args();
static void init_vars();

int max_color ;	/* don't quantize to more than this number of
			   entries */

struct image_stuff S_image_info ;
unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* RGB color map */
int S_mapnum ;		/* number of entries in color map */

char anima_format[80] ;
char outfilename[80] ;



main(argc, argv)

int argc;
char *argv[];

{
    FILE *out ;
    int i ;
    int pass_num ;	/* either 1 or 2 */
    int height, width;
    
    init_vars();

        /* parse command-line arguments */
    parse_args(argc, argv);
    if ((max_color < 1) || (max_color > S_MAX_COL_SIZE))
    {
	fprintf (stderr,"illegal setting of maximum color table entries\n") ;
	exit(0) ;
    }
    if ((out = fopen (outfilename,"w")) == NULL)
    {
	fprintf (stderr,"couldn't open output file\n") ;
	exit(0);
    }

    if(S_anima_filename[0] != '\0')
    {
	if (!getfile())
	{
	    perror ("reading anima file") ;
	    exit (0) ;
	}
	fseek(S_anima_file,0,0) ;
	    /* read IFF header */
	if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
        {  
            fprintf (stderr,"iff_read_header failed\n") ;
            exit(0) ;
        }
	fseek(S_anima_file,0,0) ;
    }

    S_anima_bytes = 0 ;
    S_image_info.s_width = width ;
    S_image_info.s_height = height ;
    S_image_info.data = (unsigned char *) malloc(S_image_info.s_height*S_image_info.s_width) ;
    
    pass_num = 1 ;
       /* main task in pass 1 is finding color frequencies for entire
	  sequence and setting up data structures */
    for (i = 0 ; i < S_anima_count ; i++)
    {
	if ((i % 10) == 0)
	    printf ("pass 1 of 2: frame %d of %d\n",i+1,S_anima_count) ;
	analyze_frame(i,pass_num,out) ;
    }
    fseek (S_anima_file,0,0) ;
    pass_num = 2 ;
	/* During the second pass the single color map for the
	   sequence is generated, and color map entries are reassigned */
    for (i = 0 ; i < S_anima_count ; i++)
    {
	if ((i % 25) == 0)
	    printf ("pass 2 of 2: frame %d of %d\n",i+1,S_anima_count) ;
	analyze_frame(i,pass_num,out) ;
    }
    anima_write_footer(out) ;
    fclose(out) ;
    free_isi_memory() ;
    free (S_image_info.data) ;
}




/* parse command-line arguments */

static void
parse_args(argc, argv)

int argc;
char *argv[];

{
    int i;
    
    max_color = S_MAX_COL_DISPLAY - 1 ;
    for(i = 1; i < argc; i++)
    {
	    if(*argv[i] != '-')
            {
		    fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
            }
	    switch(*(argv[i]+1))
            {
		case 'i':		/* input:  many map format Anima file */
		    strcpy(S_anima_filename, argv[++i]);
		    break;
		case 'o':		/* output:  one map format Anima file */
		    strcpy(outfilename,argv[++i]) ;
		    break ;
		case 'm':
		    max_color = atoi(argv[++i]) - 1;
		    break;
		case 'h':
		    fprintf(stderr,"generates one color map for Anima file\n") ;
		    fprintf(stderr,"usage:  genonemap -i input -o output -m maxcolor\n") ;
		    fprintf(stderr,"-h : this message\n");
		    exit(-1);
		default:
		    fprintf(stderr,"bad command line:  use %s -h for help\n", argv[0]);
		    exit(-1);
		}
	}
}




/* initialize miscellaneous variables */

static void
init_vars()
{
    S_anima_filename[0] = '\0';
    S_anima_file = NULL;
    max_color = S_MAX_COL_DISPLAY - 1 ;
}
