/* ccchist.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include	<stdio.h>
#include	<memory.h>
#include	<scry_image.h>

#define SIZBLOC 4	/* dimensions of bitmap */

/* ccc_histo:  finds frequency of each color,
   reading a CCC-compressed image */

ccc_histo (bufin , histo_map)

unsigned char bufin [] ;	/* compressed scan lines */
unsigned int *histo_map ;	/* histogram of each color in color map */
	
{
    unsigned char pix0, pix1 ;	/* colors inside the block */
    unsigned char *ptin ;	/* pointer for bufin */
    int i;
    unsigned int run_ctr ;
    int block_width_num ;	/* number of blocks per scan line */
    int tot_blocks ;		/* total number of blocks */

    ptin = bufin ;
    run_ctr = 1 ;
    block_width_num = S_image_info.s_width / 4 ;
    tot_blocks = block_width_num*(S_image_info.s_height/4) ;
    for (i=0 ; i<tot_blocks ; i += run_ctr)
    {
	pix0 = *ptin++ ;
	pix1 = *ptin++ ;
        if ( pix0 != pix1 )       /* if 2 colors different */
        { 
            register unsigned short bitmap ;

	    run_ctr = 1 ;
	    bitmap = *ptin++ ;
	    bitmap = (bitmap << 8) | *ptin++ ;
            if (bitmap & 01)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 02)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 04)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 010)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 020)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 040)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 0100)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 0200)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 0400)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 01000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 02000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 04000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 010000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 020000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 040000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
            if (bitmap & 0100000)
		++histo_map[pix1] ;
	    else
		++histo_map[pix0] ;
        }
        else		/* add length of run to histogram for the
			   one color in the block */
        {
	    run_ctr = *ptin++ ;
	    run_ctr = (run_ctr << 8) | *ptin++ ;
	    if (run_ctr > block_width_num)
		printf ("%s\n","error in run ctr") ;
	    histo_map[pix0] += SIZBLOC*SIZBLOC*run_ctr ;
	}
    }			/* END FOR A GROUP OF LINES */
}
